/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _MO_COLORMAPPING_
#define  _MO_COLORMAPPING_

#include <Inventor/nodes/SoNode.h>
#include <Inventor/SbColorRGBA.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
#include <MeshVizXLM/mapping/interfaces/MiColorMapping.h>
#include <MeshVizXLM/mapping/nodes/MoActionNode.h>

/**
 * @DTEXT  Abstract base class for color mapping nodes.
 * 
 * @ingroup MeshVizXLM_Mapping_Attributes
 * 
 * @DESCRIPTION
 *
 * Specific color mappping classes include:
 *   - MoCombineColorMapping: @BR
 *     Takes a custom MiColorMapping object, provided by the application,
 *     that maps a set of scalar values to a color value
 *
 *   - MoCustomColorMapping: @BR
 *     Takes a custom MiColorMapping object, provided by the application,
 *     that maps a scalar value to a color value.
 *
 *   - MoLevelColorMapping: @BR
 *     Specifies an interval color mapping defined by a set of N scalar values
 *     (thus N-1 intervals) and N-1 colors defining a constant color to be used
 *     for the values in each interval.
 *
 *   - MoLinearColorMapping: @BR
 *     Specifies a linear color mapping defined by a set of scalar values and their
 *     corresponding colors.  For a given value, the associated color c is determined
 *     by a linear interpolation between two values.
 *
 *   - MoPredefinedColorMapping: @BR
 *     Values between a specified minValue and maxValue are mapped into one of the
 *     predefined color maps.
 *
 * @SEE_ALSO
 *   MiColorMapping,
 *   MoCombineColorMapping,
 *   MoCustomColorMapping,
 *   MoLevelColorMapping,
 *   MoLinearColorMapping,
 *   MoPredefinedColorMapping
 * 
 */
class MESHVIZXLM_DMAP_API MoColorMapping : public MoActionNode {

  SO_NODE_HEADER(MoColorMapping) ;
  
 public:

 /*----------------------------------------------------------------------------*/
  SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
  SoEXTENDER public:
  virtual void  doAction(SoAction *action) ;

 protected:
  MoColorMapping() ;

  virtual ~MoColorMapping() ;
  
  const MiColorMapping<double,SbColorRGBA>* m_colorMapping;
} ; 

#endif /* _MO_COLORMAPPING_  */

