/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _MO_DATABINDING_
#define  _MO_DATABINDING_

#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/nodes/SoNode.h>

#include <MeshVizXLM/mapping/nodes/MoActionNode.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
 
/**
 * @DTEXT Property node that defines the data binding.
 * 
 * @ingroup MeshVizXLM_Mapping_Attributes
 * 
 * @DESCRIPTION
 * This node specifies the data binding to be used in subsequent representations.
 * When set to AUTO (default), the data binding is taken from the data set element.
 *
 * In some cases, particularly for Unstructured IJK meshes, it is not possible for
 * MeshViz to know which data binding to use. In this case, use this node to set it.
 *
 * In general it is not necessary to use this node if your application uses MoScalarSet
 * (instead of MoScalarSetI and MoScalarSetIjk) to reference scalar data sets in the
 * scene graph.
 *
 * @FILE_FORMAT_DEFAULT
 *    DataBinding {
 *    @TABLE_FILE_FORMAT
 *       @TR dataBinding           @TD AUTO
 *    @TABLE_END
 *    }
 *
 * @ACTION_BEHAVIOR
 *   Sets the current data binding.  See MoDataBindingElement.
 *
 * @SEE_ALSO
 *   MoScalarSet, MoScalarSetI, MoScalarSetIj, MoScalarSetIjk
 */
class MESHVIZXLM_DMAP_API MoDataBinding : public MoActionNode {

  SO_NODE_HEADER(MoDataBinding) ;
  
 public:

  /**
   * Constructor.
   */
  MoDataBinding() ;

  /** Data Binding */
  enum DataBinding {
    AUTO=-1,  /**< Use the data binding of the current data set */
    PER_CELL, /**< The data set contains one data value per cell. */
    PER_NODE  /**< The data set contains one data value per node. */
  };

  /** 
  * The data binding to be used in subsequent representations.
  * Use enum #DataBinding. Default is AUTO.
  * When set to AUTO (default), the data binding is taken from the data set element.
  * In some cases, particularly for Unstructured IJK meshes, it is not possible to know which 
  * Data Binding to use. In this case, use this attribute to set it.
  */
  SoSFEnum dataBinding;
   

 /*----------------------------------------------------------------------------*/
  SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
  SoEXTENDER public:
  virtual void  doAction(SoAction *action) ;

protected:
  virtual ~MoDataBinding() ;

} ; 

#endif /* _MO_DATABINDING_  */

