/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MoLegend_
#define  _MoLegend_

#include <MeshVizXLM/mapping/nodes/MoMeshBaseRepresentation.h>
#include <MeshVizXLM/mapping/interfaces/MiColorMapping.h>

#include <MeshVizXLM/MbVec3.h>

#include <Inventor/misc/SoRef.h>
#include <Inventor/caches/SoCache.h>
#include <Inventor/fields/SoSFDouble.h>
#include <Inventor/fields/SoSFVec2f.h>
#include <Inventor/fields/SoSFUInt32.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class SoState;
class SbColorRGBA;
class MdSurfaceMeshRectilinear;

class MxScalarSetIj;
class MdSurfaceMesh;
class MdLevelColorMapping;
class MdLinearColorMapping;
class MdPredefinedColorMapping;


/**
* @DTEXT  Rendering node that displays a legend.
* 
* @ingroup MeshVizXLM_Mapping_Representation
* 
* @DESCRIPTION
*  Displays a legend representing the current colormap.
*  A colormap is specified using the MoColorMapping derived nodes. 
*  However, the legend does not take into account the MoCombineColorMapping node.
*
* The legend is drawn in a rectangle defined by the bottomLeft and topRight 
* 2D points given in Normalized Device Coordinates [0..1].
* 
* @FILE_FORMAT_DEFAULT
*    Legend {
*    @TABLE_FILE_FORMAT
*       @TR bottomLeft        @TD SbVec3f(0,0)
*       @TR topRight          @TD SbVec3f(0,1)
*       @TR minValue          @TD 0
*       @TR maxValue          @TD 0
*       @TR vertical          @TD FALSE
*       @TR title             @TD ""
*       @TR titleColor        @TD 0.8 0.8 0.8
*       @TR titleFontSize     @TD 10
*       @TR titlePosition     @TD POS_BOTTOM
*       @TR displayValues     @TD FALSE
*       @TR valuesColor       @TD 0.8 0.8 0.8
*       @TR valuesFontSize    @TD 10
*       @TR valueNotation;    @TD NOTATION_DEFAULT
*       @TR valuePrecision    @TD 0
*    @TABLE_END
*    }
*
* @SEE_ALSO
*  MoColorMapping
* 
*/

class MESHVIZXLM_DMAP_API MoLegend : public MoMeshBaseRepresentation {

  SO_NODE_HEADER(MoLegend) ;

public:

  /**
  * Constructor.
  */
  MoLegend() ;

  /**
  * Bottom left corner of the rectangle in which the legend will be drawn.
  * In NDC units [0..1]. Default is (0,0).
  */
  SoSFVec2f bottomLeft;

  /**
  * Top-right corner of the rectangle in which the legend will be drawn.
  * In NDC units [0..1]. Default is (0,1).
  */
  SoSFVec2f topRight;

  /**
  * The minimum value defining the range of data to display in the legend.
  * Default 0.
  * @note If not set, the min and max values are retrieved from the colormap.
  */
  SoSFDouble minValue;

  /**
  * The maximum value defining the range of data to display in the legend.
  * Default 0.
  * @note If not set, the min and max values are retrieved from the colormap.
  */
  SoSFDouble maxValue;

  /**
  * If TRUE, the legend is vertical. Otherwise it is horizontal.
  * Default FALSE (horizontal)
  */
  SoSFBool vertical;

  /**
  * The title of the legend.
  */
  SoSFString title;

  /**
  * The size of the font for the title of the legend. Default 10 pixels.
  */
  SoSFFloat titleFontSize;

  /**
  * Color for the title of the legend.
  */
  SoSFColor titleColor;

  /**
   *  Position of the title.
   */
  enum Position {   
    POS_BOTTOM,  /**< Bottom. */
    POS_TOP,     /**< Top.    */
    POS_RIGHT,   /**< Right.  */
    POS_LEFT     /**< Left.   */
  } ;

  /**
  * The position of the title relative to the legend box. 
  * Use enum #Position. Default is POS_BOTTOM.
  */
  SoSFEnum titlePosition;

  /**
  * If TRUE, display numValues values starting from the minimal to 
  * the maximal values of the colormap. 
  * Default FALSE.
  */
  SoSFBool displayValues;


  /**
  * The number of values displayed near the colorbar. 
  * This field is ignored if displayValues is FALSE.
  * Default 2.
  */
  SoSFInt32 numValues;

  /**
  * Color for the values of the legend.
  */
  SoSFColor valuesColor;
	
  /**
  * The size of the font for the values of the legend. Default 10 pixels.
  */
  SoSFFloat valuesFontSize;

  /**
  *  Notation type of the values.
  */
  enum Notation {
    NOTATION_DEFAULT,
    NOTATION_FIXED,
    NOTATION_SCIENTIFIC
  };

  /**
  * Defines the notation type (fixed or scientific) used to display the
  * values of this legend.
  * @useenum{Notation}. Default is NOTATION_DEFAULT.
  *
  * Note: The field #valuePrecision is interpreted according to valueNotation.
  *
  * @FIELD_SINCE_OIV 9.6
  */
  SoSFEnum valueNotation;

  /**
  * Defines the maximum number of significant digits to display, or the maximum
  * number of digits after the decimal point depending on the value of the 
  * field #valueNotation. Default value is 0.
  *
  * When using #NOTATION_DEFAULT the valuePrecision field specifies the maximum 
  * number of meaningful digits to display in total counting both those before 
  * and those after the decimal point. Notice that it is not a minimum, and 
  * therefore it does not pad the displayed number with trailing zeros if 
  * the number can be displayed with less digits than the precision.
  *
  * When using #NOTATION_FIXED or #NOTATION_SCIENTIFIC, the precision field 
  * specifies exactly how many digits to display after the decimal point, 
  * even if this includes trailing decimal zeros. The digits before the 
  * decimal point are not relevant for
  * the precision in this case.
  *
  * @FIELD_SINCE_OIV 9.6
  */
  SoSFUInt32 valuePrecision;

  /*----------------------------------------------------------------------------*/
  SoEXTENDER public:
  virtual void doAction(SoAction *action);

  SoINTERNAL public:
  static void initClass() ;
  static void exitClass() ;

protected:
  virtual ~MoLegend() ;  

  void fillLegend(SoState* state);
  void fillLevelCM(SoState* state, const MdLevelColorMapping& levelCM);
  void fillLinearCM(SoState* state, const MdLinearColorMapping& linearCM);
  void fillPredefCM(SoState* state, const MdPredefinedColorMapping& predefCM);
  void fillCustomCM(SoState* state, const MiColorMapping<double,SbColorRGBA>& customCM);
  void createMesh(SoState* state, int ind, std::vector<float>& coords0, std::vector<float> coords1, float xmin, float xmax, double vmin, double vmax);
  void getLegendRange(const MiColorMapping<double, SbColorRGBA>& cmap,double& vmin,double& vmax);

  void drawTitle(SoState* state);
  void drawValues(SoState* state,double vmin, double vmax);
  
  void clear();

  MdSurfaceMesh* m_surface;
  SoSeparator*   m_textGroup;
  SoSeparator*   m_valuesGroup;
  MdSurfaceMeshRectilinear* m_legendMesh;
  MxScalarSetIj* m_scalarSet;
private:
  /** cache managing dependency on MoColorMappingElement */
  SoRef<SoCache> m_cache;
  void buildCache( SoState *state );
  SbBool checkCache( SoState *state );
} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MoLegend_ */



