/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHCYLINDERSLICE_
#define  _MO_MESHCYLINDERSLICE_

#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoSFVec3f.h>

#include <MeshVizXLM/MbVec3.h>

#include <MeshVizXLM/mapping/nodes/MoMeshSurfaceRepresentation.h>
#include <MeshVizXLM/extractors/MiCylinderSliceExtractUnstructuredIjk.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class MiCylinderSliceExtractUnstructured;
class MiCylinderSliceExtractHexahedronIjk;
class MiCylinderSliceExtractIjk;

/**
 * @DTEXT  Rendering node that displays a cylinder slice of a volume mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *  A cylinder slice is an unstructured surface mesh defined by the intersection of an
 *  infinite cylinder with a volume mesh. 
 *  The cylinder is defined by a position, a radius and a direction vector.
 *
 *  The slice can be colored using a scalar set defined in the colorScalarSetId inherited field.
 *  This is an index into the list of scalar sets existing in the traversal state
 *  (see the MoScalarSetxxx nodes). To disable coloring set this field to -1.
 *  Rendering can be modified using various property nodes (see the SEE ALSO section).
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshCylinderSlice {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId           @TD 0
 *       @TR parallel                   @TD TRUE
 *       @TR center                     @TD 0,0,0
 *       @TR radius                     @TD 1.0
 *       @TR direction                  @TD 1,0,0
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *  MoCellFilter, MoColorMapping, MoDrawStyle, MoMaterial, MoFaceDetail, @BR
 *  MiCylinderSliceExtractIjk, 
 *  MiCylinderSliceExtractUnstructured,
 *  MiCylinderSliceExtractHexahedronIjk
 *  
 */

class MESHVIZXLM_DMAP_API MoMeshCylinderSlice : public MoMeshSurfaceRepresentation {

  SO_NODE_HEADER(MoMeshCylinderSlice) ;

 public:

  /**
   * Constructor.
   */
  MoMeshCylinderSlice() ;

  /**
   * Specifies the cylinder's center. Default is 0,0,0.
   */
  SoSFVec3f center;

  /**
   * Specifies the cylinder's radius. Value must be greater than 0.0.  Default is 1.
   */
  SoSFFloat radius;

  /**
   * Specifies the cylinder's direction. Default is 1,0,0.
   */
  SoSFVec3f direction;

  //@{
  /** 
  * Get extractor for reuse outside this node. 
  * @note  The returned pointer may be null if a mesh has not been set in the scene graph 
  * or if no render action traversal has been done yet.
  */
  const MiCylinderSliceExtractUnstructured*     getUnstructuredExtractor();
  const MiCylinderSliceExtractHexahedronIjk*  getHexahedronIjkExtractor();
  const MiCylinderSliceExtractIjk*              getIjkExtractor();
  //@}

#if SoDEPRECATED_BEGIN(10000)
  SoDEPRECATED_METHOD(10000,"Use getHexahedronIjkExtractor() instead.")
    const MiCylinderSliceExtractHexahedronIjk*  getUnstructuredIjkExtractor();
#endif /** @DEPRECATED_END */

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract(SoAction *action);

 protected:
  virtual ~MoMeshCylinderSlice() ;  

} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHCYLINDERSLICE_ */



