/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHINTERPOLATEDLOGICALSLICE_
#define  _MO_MESHINTERPOLATEDLOGICALSLICE_

#include <MeshVizXLM/MbVec3.h>
#include <MeshVizXLM/extractors/MiBaseLogicalSliceExtract.h>

#include <MeshVizXLM/mapping/nodes/MoMeshSurfaceRepresentation.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#pragma warning(disable:4996)
#endif

class MiInterpolatedLogicalSliceExtractHexahedronIjk;
class MiInterpolatedLogicalSliceExtract;

/**
 * @DTEXT  Rendering node that displays an interpolated logical slice of a volume mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *  An interpolated logical slice is similar to MoMeshLogicalSlice except that instead of 
 *  displaying the slice only on the face of the cells, it can interpolate a slice inside cells. 
 *  This is done by providing a floating point value representing the offset along the specified axis.
 *
 *  The slice can be colored using a scalar set defined in the colorScalarSetId inherited field.
 *  This is an index into the list of scalar sets existing in the traversal state
 *  (see the MoScalarSetxxx nodes). To disable coloring set this field to -1.
 *  Rendering can be modified using various property nodes (see the SEE ALSO section).
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshInterpolatedLogicalSlice {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId           @TD 0
 *       @TR parallel                   @TD TRUE
 *       @TR sliceValue                 @TD 0
 *       @TR sliceAxis                  @TD MiMesh::Dimension::I
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *  MoMeshLogicalSlice, MoMeshSlab, @BR
 *  MoCellFilter, MoColorMapping, MoDrawStyle, MoMaterial, @BR
 *  MiInterpolatedLogicalSliceExtract, 
 *  MiInterpolatedLogicalSliceExtractHexahedronIjk, MoFaceDetail
 * 
 */

class MESHVIZXLM_DMAP_API MoMeshInterpolatedLogicalSlice : public MoMeshSurfaceRepresentation {

  SO_NODE_HEADER(MoMeshInterpolatedLogicalSlice) ;

 public:

  /**
   * Constructor.
   */
  MoMeshInterpolatedLogicalSlice() ;

  /**
   * Value of the slice to display between 0 and NUM CELL. Default is 0.
   */
  SoSFFloat  sliceValue;

  /**
  * The dimension along which the logical slice will be computed.
  * Use enum #MiMesh::Dimension. Default is MiMesh::Dimension::I.
  */
  SoSFEnum  sliceAxis;

  /** 
  * Get extractor for reuse outside this node. 
  * @note The returned pointer may be null if a mesh has not been set in the scene graph 
  * or if no render action has traversed the scene graph.
  */
  const MiInterpolatedLogicalSliceExtractHexahedronIjk*    getHexahedronIjkExtractor();
  const MiInterpolatedLogicalSliceExtract*                 getIjkExtractor();

#if SoDEPRECATED_BEGIN(10000)
  SoDEPRECATED_METHOD(10000,"Use getHexahedronIjkExtractor() instead.")
  const MiInterpolatedLogicalSliceExtractHexahedronIjk*    getUnstructuredIjkExtractor();
#endif /** @DEPRECATED_END */

#if SoDEPRECATED_BEGIN(9300)

  class SoDEPRECATED_CLASS(9300, "use MiMesh::Dimension instead.") SliceAxis
  {
  public:
    static const MiMesh::Dimension SLICE_I = MiMesh::DIMENSION_I; /**< Slice at I constant */
    static const MiMesh::Dimension SLICE_J = MiMesh::DIMENSION_J; /**< Slice at J constant */
    static const MiMesh::Dimension SLICE_K = MiMesh::DIMENSION_K; /**< Slice at K constant */

    // constructors + operators
    SliceAxis() : m_axis(MiMesh::DIMENSION_I) {}
    SliceAxis(MiMesh::Dimension a) : m_axis(a) {}
    SliceAxis(int a) : m_axis((MiMesh::Dimension)a) {}
    SliceAxis(size_t a) : m_axis((MiMesh::Dimension)a) {}
    operator MiMesh::Dimension() const { return m_axis; }

  private:
    MiMesh::Dimension m_axis;
  };

  SoDEPRECATED_METHOD(9300,"Use MiMesh::Dimension instead.")
  static const MiMesh::Dimension SLICE_I = MiMesh::DIMENSION_I; /**< Slice at I constant */

  SoDEPRECATED_METHOD(9300,"Use MiMesh::Dimension instead.")
  static const MiMesh::Dimension SLICE_J = MiMesh::DIMENSION_J; /**< Slice at J constant */

  SoDEPRECATED_METHOD(9300,"Use MiMesh::Dimension instead.")
  static const MiMesh::Dimension SLICE_K = MiMesh::DIMENSION_K; /**< Slice at K constant */ 

#endif /** @DEPRECATED_END */

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract(SoAction *action);

} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHINTERPOLATEDLOGICALSLICE_ */



