/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHLINE_
#define  _MO_MESHLINE_

#include <MeshVizXLM/mapping/nodes/MoMeshLineRepresentation.h>

class MdMeshRepresentation;

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif


/**
 * @DTEXT  Rendering node that displays a line mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *    This class gets the MoMesh node from the scene graph and renders the described line by this MoMesh.
 *    The MoMesh stored in the scene graph must be a line mesh.
 *
 * \if_cpp
 *  @note It only performs an extraction for quadratic meshes and in this case, a MoTessellator must be set 
 *        in the scenegraph for proper rendering.
 * \endif
 *
 *    The line mesh can be colored using a scalar set defined in the colorScalarSetId inherited field.
 *    This is an index into the list of scalar sets existing in the traversal state
 *    (see the MoScalarSetxxx nodes). To disable coloring set this field to -1.
 *
 *    If this shape is picked, SoPickedPoint will return a subclass of MoLineDetail.
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshLine {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId           @TD 0
 *       @TR parallel                   @TD TRUE
 *    @TABLE_END
 *    }
 * 
 * @SEE_ALSO
 *  MoMesh, 
 *  MoTessellator,
 *  MoLineDetail
 *
 */

class MESHVIZXLM_DMAP_API MoMeshLine : public MoMeshLineRepresentation {

  SO_NODE_HEADER(MoMeshLine) ;

 public:

  /**
   * Constructor.
   */
  MoMeshLine() ;

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract(SoAction *action);

} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHLINE_ */



