/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHLOGICALSLICE_
#define  _MO_MESHLOGICALSLICE_

#include <MeshVizXLM/mapping/nodes/MoMeshSurfaceRepresentation.h>

#include <Inventor/fields/SoSFUInt32.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#pragma warning(disable:4996)
#endif

class MiLogicalSliceExtractHexahedronIjk;
class MiLogicalSliceExtractRegular;
class MiLogicalSliceExtractRectilinear;
class MiLogicalSliceExtractCurvilinear;

/**
 * @DTEXT  Rendering node that displays a logical slice of a structured volume mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 * A logical slice is an unstructured surface mesh extracted from an IJK volume mesh along the 
 * upper or lower faces of a "row" of cells. It is defined by a slice axis, an index and a boolean flag. 
 * 
 * The slice axis can be MiMesh::Dimension::I, MiMesh::Dimension::J or MiMesh::Dimension::K. 
 * The index represents a constant value for I, J or K (whichever is the slice axis). 
 * The boolean upperVertex specifies whether the slice is rendered using the lower or upper vertices
 * (roughly the near or far faces) of the cells.
 *
 * If N is the number of cells on the specified sliceAxis, then the valid range for sliceIndex
 * is 0..N.  As a convenience, when sliceIndex = N, the N-1 cells are used but upperVertex is 
 * automatically considered to be TRUE.
 *
 * The slice can be colored using a scalar set defined in the colorScalarSetId inherited field.
 * This is an index into the list of scalar sets existing in the traversal state
 * (see the MoScalarSetxxx nodes). To disable coloring set this field to -1.
 * Rendering can be modified using various property nodes (see the SEE ALSO section).
 *
 * An MoMeshLogicalSlice is extracted along one face of each cell and so has no "thickness" along the slice axis.
 * MoMeshInterpolatedLogicalSlice is similar, but instead of displaying the slice only on the face of the cells, 
 * it can interpolate a slice inside cells. MoMeshSlab is related, but extracts all visible faces from a row of
 * cells with the same index in the given dimension I, J or K.
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshLogicalSlice {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId           @TD 0
 *       @TR parallel                   @TD TRUE
 *       @TR sliceIndex                 @TD 0
 *       @TR sliceAxis                  @TD MiMesh::Dimension::I
 *       @TR upperVertex                @TD FALSE
 *    @TABLE_END
 *    }
 * 
 * @SEE_ALSO
 *  MoMeshSlab, MoMeshInterpolatedLogicalSlice, @BR
 *  MoCellFilter, MoColorMapping, MoDrawStyle, MoMaterial, @BR
 *  MiLogicalSliceExtractRegular, 
 *  MiLogicalSliceExtractRectilinear,
 *  MiLogicalSliceExtractCurvilinear, 
 *  MiLogicalSliceExtractHexahedronIjk, MoFaceDetail
 *
 */

class MESHVIZXLM_DMAP_API MoMeshLogicalSlice : public MoMeshSurfaceRepresentation {

  SO_NODE_HEADER(MoMeshLogicalSlice) ;

 public:

  /**
   * Constructor.
   */
  MoMeshLogicalSlice() ;

  /**
   * Index of the slice to display. Default is 0.
   */
  SoSFUInt32  sliceIndex;

  /**
  * The dimension along which the logical slice will be computed defined by the MiMesh::Dimension enum.
  * Default is MiMesh::Dimension::I.
  */
  SoSFEnum  sliceAxis;
  
  /**
  * If FALSE (the default), displays the lower part of the cell, otherwise displays the upper part of the cell.
  */
  SoSFBool  upperVertex;

  /** 
  * Get extractor for reuse outside this node. 
  * @note  The returned pointer may be null if a mesh has not been set in the scene graph 
  * or if no render action has been called before. 
  * Use the method corresponding to the type of mesh stored in the scene graph. 
  * 
  */
  const MiLogicalSliceExtractRegular*         getRegularExtractor();
  const MiLogicalSliceExtractRectilinear*     getRectilinearExtractor();
  const MiLogicalSliceExtractCurvilinear*     getCurvilinearExtractor();
  const MiLogicalSliceExtractHexahedronIjk*   getHexahedronIjkExtractor();

#if SoDEPRECATED_BEGIN(10000)
  SoDEPRECATED_METHOD(10000,"Use getHexahedronIjkExtractor() instead.")
  const MiLogicalSliceExtractHexahedronIjk* getUnstructuredIjkExtractor();
#endif /** @DEPRECATED_END */

#if SoDEPRECATED_BEGIN(9300)

  class SoDEPRECATED_CLASS(9300, "use MiMesh::Dimension instead.") SliceAxis
  {
  public:
    static const MiMesh::Dimension SLICE_I = MiMesh::DIMENSION_I; /**< Slice at I constant */
    static const MiMesh::Dimension SLICE_J = MiMesh::DIMENSION_J; /**< Slice at J constant */
    static const MiMesh::Dimension SLICE_K = MiMesh::DIMENSION_K; /**< Slice at K constant */

    // constructors + operators
    SliceAxis() : m_axis(MiMesh::DIMENSION_I) {}
    SliceAxis(MiMesh::Dimension a) : m_axis(a) {}
    SliceAxis(int a) : m_axis((MiMesh::Dimension)a) {}
    SliceAxis(size_t a) : m_axis((MiMesh::Dimension)a) {}
    operator MiMesh::Dimension() const { return m_axis; }

  private:
    MiMesh::Dimension m_axis;
  };

  SoDEPRECATED_METHOD(9300,"Use MiMesh::Dimension instead.")
  static const MiMesh::Dimension SLICE_I = MiMesh::DIMENSION_I; /**< Slice at I constant */

  SoDEPRECATED_METHOD(9300,"Use MiMesh::Dimension instead.")
  static const MiMesh::Dimension SLICE_J = MiMesh::DIMENSION_J; /**< Slice at J constant */

  SoDEPRECATED_METHOD(9300,"Use MiMesh::Dimension instead.")
  static const MiMesh::Dimension SLICE_K = MiMesh::DIMENSION_K; /**< Slice at K constant */ 

#endif /** @DEPRECATED_END */

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract(SoAction *action);
  
} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHLogicalSlice_ */



