/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
** Modified by : M. Bonaventure (Avr 2010)
**=======================================================================*/
#ifndef  _MO_MESHREPRESENTATION_
#define  _MO_MESHREPRESENTATION_

#include <MeshVizXLM/mapping/nodes/MoMeshBaseRepresentation.h>
#include <Inventor/fields/SoSFNode.h>
#include <Inventor/sensors/SoFieldSensor.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/mesh/data/MiDataSetIj.h>
#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>

class MiMesh;
class MiExtractorCallback;
class MiTessellator;

class MoMeshDetail;

class SoRayPickAction;

class MdMeshRepresentation;
class MdMeshCache;
class MxAttributesManager;
class MdProfilingTool;

/**
 * @DTEXT  Abstract base class for all MeshViz XLM representation nodes containing an extractor.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *    Abstract base class for all MeshViz XLM representation nodes containing an extractor.
 *
 *    The basic representations and the meshes they apply to are:
 *    - Volume mesh
 *      - MoMeshCellShape
 *      - MoMeshClipLine
 *      - MoMeshCylinderSlice
 *      - MoMeshGridPlaneSlice
 *      - MoMeshInterpolatedLogicalSlice
 *      - MoMeshIsosurface
 *      - MoMeshLogicalSlice
 *      - MoMeshOutline
 *      - MoMeshPlaneSlice
 *      - MoMeshSkin
 *      - MoMeshSphereSlice
 *      - MoMeshStreamline
 *      - MoMeshVector
 *    - Surface mesh
 *      - MoMeshAnnotatedIsoline
 *      - MoMeshCellShape
 *      - MoMeshIsoline
 *      - MoMeshOutline
 *      - MoMeshVector
 *    - Line mesh
 *      - MoMeshVector
 * 
 *   All surface representations, for instance MoMeshIsosurface and MoMeshSkin, are using an inner SoPolygonOffset node
 *   to allow line representations, such as MoMeshIsoline and MoMeshOutline, on top without artifacts.
 *   However SoPolygonOffset can introduce other artifacts on surfaces when the two-sided lighting mode is active.
 *   Thus, to disable this SoPolygonOffset node, set the MESHVIZ_POLYGON_OFFSET environment variable to false (See SoPreferences).
 */

class MESHVIZXLM_DMAP_API MoMeshRepresentation : public MoMeshBaseRepresentation {

  SO_NODE_HEADER(MoMeshRepresentation) ;

 public:

  /**
  * Field representing the scalar set node to be used to map colors onto the representation.
  * During traversal of the scene graph, scalar set nodes are accumulated in a list of scalar sets.
  * colorScalarSetId is an index into this list. 
  * Default value is 0 which means that the first scalar set stored in the scene graph is used.
  * Setting this value to -1 disables color mapping 
  */
  SoSFInt32 colorScalarSetId;

  /**
  * If TRUE, the node tries to launch the extraction in parallel if this is supported by the associated extractor.
  * Extractions performed in parallel use multiple cores and/or processors to compute the extraction.
  * Default is TRUE.
  */
  SoSFBool parallel;

  /**
  * Set the extraction callback which will be called each time an extraction is performed.
  * For instance, this callback allows the application to update a progress bar during the 
  * extraction process. Remove the callback if extractorCallback is NULL.
  */
  virtual void setExtractorCallback(MiExtractorCallback* extractorCallback);

  SoDEPRECATED_METHOD(9400,"Use setExtractorCallback(MiExtractorCallback*) instead")
  virtual void setExtractorCallback(MiExtractorCallback& extractorCallback);

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:

  static void initClass() ;
	static void exitClass() ;

  size_t getTimeStamp() const;

  // computes the extract of the given data set.
  virtual const MiScalardSet* extractScalarSet(const MiScalardSet* SO_UNUSED_PARAM(scalarSet));

  /**
  * Return true if the extractor is currently using a Tessellator
  */
  bool isUsingTessellator() const;

 SoEXTENDER public:
  virtual void rayPick(SoRayPickAction *action);
  virtual void doExtract(SoAction *action) = 0;
  virtual void doAction(SoAction *action);

  // Method used to return the extracted mesh computed by the representation used by MoMesh::connectFrom()
  const MiMesh* getExtractedMesh(MeshType& meshType);

  // computes the extract of the data set corresponding to the given index in the state list from the current representation's extractor.
  virtual const MiScalardSetI* extractScalarSetI(SoState * SO_UNUSED_PARAM(state),size_t SO_UNUSED_PARAM(scalarSetId));
  virtual const MiScalardSetIj* extractScalarSetIj(SoState * SO_UNUSED_PARAM(state),size_t SO_UNUSED_PARAM(scalarSetId));

  // computes the extract of the data set corresponding to the given index in the state list from the current representation's extractor.
  virtual const MiVec3dSetI* extractVec3SetI(SoState * SO_UNUSED_PARAM(state),size_t SO_UNUSED_PARAM(vec3SetId));
  virtual const MiVec3dSetIj* extractVec3SetIj(SoState * SO_UNUSED_PARAM(state),size_t SO_UNUSED_PARAM(vec3SetId));

 protected:
  MoMeshRepresentation() ;
  virtual ~MoMeshRepresentation() ;  

  friend class MdUndefinedMeshRepresentation;
  template<typename _ExtractorT> friend class MdMeshRepresentationFor;
  template <typename _MdExtractorT> friend class MdMeshMultiLinesRepresentation;
  template<typename _MdExtractorT> friend class MdExtractionThread;

  const MiMesh* getMeshFromState(SoState* state, MeshType& meshType);
  MiTessellator* getTessellatorFromState(SoState* state, bool ignoreCache = false);
  template <typename _MeshInterface>
  std::vector<const MiScalardSet*> getColorSetFromState(SoState* state);

  virtual void clear();

  MdMeshRepresentation* m_nodeImpl;
  MiExtractorCallback* m_extractorCallback;

private:
  // Parallel field sensor
  SoFieldSensor m_parallelFieldSensor;
  static void parallelFieldSensorCB(void* data, SoSensor* sensor);
  // detail storing the current mesh and the color scalarset
  MoMeshDetail* m_meshDetail;
  // Internal mechanism to retrieve the attributes for the extractions
  MxAttributesManager* m_attributesManager;
  // time stamp is updated when creating a new the representation meshcache 
  size_t m_timeStamp;
  // set to true if the extractor is currentlty using a Tessellator
  bool m_usingTessellator;
  // Mesh cache 
  MdMeshCache* m_meshCache;

  MdProfilingTool* m_profiling;

};

#endif /* _MO_MESHREPRESENTATION_ */



