/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHSKIN_
#define  _MO_MESHSKIN_

#include <Inventor/fields/SoMFUInt32.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSurfaceRepresentation.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class MiSkinExtractUnstructured;
class MiSkinExtractHexahedronIjk;
class MiSkinExtractIjk;

class MdMeshRepresentation;

/**
 * @DTEXT  Rendering node that displays the skin of a volume mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *  The skin of a mesh is an unstructured surface mesh made up of all the faces that belong to only one cell.
 *
 *  The mesh can be colored using a scalar set defined in the colorScalarSetId inherited field.
 *  This is an index into the list of scalar sets existing in the traversal state
 *  (see the MoScalarSet node). To disable coloring set this field to -1.
 *
 *  Rendering can be modified using various property nodes (see the SEE ALSO section).
 *  - MoCellFilter specifies an optional cell filter to exclude cells from the skin.
 *  - MoDrawStyle controls the visibility of faces, edges and vertices in the rendering.
 *  - MoMaterial controls whether faces, edges and vertices are drawn with a single color
 *    or colored according to a scalar set.  It also specifies the color for single color
 *    faces, edges and vertices.
 *  - MoColorMapping subclasses specify the mapping from scalar values to color and opacity.
 *
 *  The skin can be extracted for a subset of the mesh using the minCellRanges and/or maxCellRanges fields.
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshSkin {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId  @TD 0
 *       @TR parallel          @TD TRUE
 *       @TR minCellRanges     @TD empty
 *       @TR maxCellRanges     @TD empty
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *  MoCellFilter, MoColorMapping, MoDrawStyle, MoMaterial, MoScalarSet, @BR
 *  MiSkinExtractIjk,
 *  MiSkinExtractUnstructured,
 *  MiSkinExtractHexahedronIjk, MoFaceDetail
 * 
 */

class MESHVIZXLM_DMAP_API MoMeshSkin : public MoMeshSurfaceRepresentation {

  SO_NODE_HEADER(MoMeshSkin) ;

 public:

  /**
  * Constructor.
  */
  MoMeshSkin() ;

  /**
  * Minimum cell index values for extracting the mesh skin to display.
  * This field is empty by default.
  * - If the field is empty, the skin extraction starts from the first cell of the mesh.
  * - If the mesh is unstructured, a single value specifies the index of the first cell index to use.
  * - If the mesh is a structured volume mesh, three values specify the first I, J and K cell indices to use. @BR
  *   (In this case, if less than three values are provided, the field is ignored.)
  */
  SoMFUInt32  minCellRanges;

  /**
  * Maximum cell index values for extracting the mesh skin to display.
  * This field is empty by default.
  * - If the field is empty, the skin extraction runs up to the last cell of the mesh. 
  * - If the mesh is unstructured, a single value specifies the index of the last cell index to use.
  * - If the mesh is a structured volume mesh, three values specify the last I, J and K cell indices to use. @BR
  *   (In this case, if less than three values are provided, the field is ignored.)
  */
  SoMFUInt32  maxCellRanges;

  //@{
  /** 
  * Get extractor for reuse outside this node. 
  * @note  The returned pointer may be null if a mesh has not been set in the scene graph 
  * or if no render action has been called before.
  */
  const MiSkinExtractUnstructured* getUnstructuredExtractor();
  const MiSkinExtractHexahedronIjk* getHexahedronIjkExtractor();
  const MiSkinExtractIjk* getIjkExtractor();
  //@}

#if SoDEPRECATED_BEGIN(10000)
  SoDEPRECATED_METHOD(10000,"Use getHexahedronIjkExtractor() instead.")
  const MiSkinExtractHexahedronIjk* getUnstructuredIjkExtractor();
#endif /** @DEPRECATED_END */

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract(SoAction *action);

} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHSKIN_ */



