/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _MO_PREDEFINEDCOLORMAPPING_
#define  _MO_PREDEFINEDCOLORMAPPING_

#include <Inventor/fields/SoMFVec4f.h>

#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
#include <MeshVizXLM/mapping/nodes/MoColorMapping.h>
#include <MeshVizXLM/mapping/interfaces/MiColorMapping.h>

class MdPredefinedColorMapping;

/**
* @DTEXT  Property node that selects a predefined color mapping.
* 
* @ingroup MeshVizXLM_Mapping_Attributes
* 
* @DESCRIPTION
* The range of the scalar values must be given to adjust the color map to the scalar set. 
* If a value is less than #minValue, the first color in the map is used.
* If a value is greater than #maxValue, the last color in the map is used.
* If a value is between #minValue and #maxValue, linear interpolation is used
* to determine the color.
*
* @FILE_FORMAT_DEFAULT
*    PredefinedColorMapping {
*    @TABLE_FILE_FORMAT
*       @TR minValue           @TD 0
*       @TR maxValue           @TD 1
*       @TR predefColorMap     @TD NONE
*    @TABLE_END
*    }
*
* @ACTION_BEHAVIOR
*   Sets the current color mapping.  See MoColorMappingElement.
*
* @SEE_ALSO
*   MoCombineColorMapping,
*   MoCustomColorMapping,
*   MoLevelColorMapping,
*   MoLinearColorMapping
* 
*/
class MESHVIZXLM_DMAP_API MoPredefinedColorMapping : public MoColorMapping {

  SO_NODE_HEADER(MoPredefinedColorMapping) ;

public:

  /**
  * Constructor.  The initial color map is NONE (node has no effect).
  */
  MoPredefinedColorMapping() ;

  //@{
  /**
  * The min and max values defining the range of scalar values.
  * Default values are 0 and 1.
  */
  SoSFFloat minValue;
  SoSFFloat maxValue;
  //@}

  /**
  * Predefined colormaps.
  */
  enum PredefColorMapping{
    NONE,           /**< Turn off color mapping (Default value)*/
    GREY,           /**< Greyscale color map */
    TEMPERATURE,    /**< Temperature color map */
    PHYSICS,        /**< Physics color map */
    STANDARD,       /**< Standard color map */
    GLOW,           /**< Glow color map */
    BLUE_RED,       /**< Blue to Red color map */
    SEISMIC,        /**< Seismic color map */
    BLUE_WHITE_RED, /**< Blue to White to Red color map */
    INTENSITY,      /**< Intensity color map */
    RAINBOW_TURBO   /**< Turbo (improved rainbow) color map */
   } ;

  /**
   * Predefined color map to use.
   * Use enum #PredefColorMapping. Default is NONE.
   *
   *    @TABLE_0B
   *       @TR NONE           @TD Default (node is ignored)
   *       @TR GREY or GRAY   @TD @IMAGE grayColorMap.jpg
   *       @TR TEMPERATURE    @TD @IMAGE temperatureColorMap.jpg
   *       @TR PHYSICS        @TD @IMAGE physicsColorMap.jpg
   *       @TR STANDARD       @TD @IMAGE standardColorMap.jpg
   *       @TR GLOW           @TD @IMAGE glowColorMap.jpg
   *       @TR BLUE_RED       @TD @IMAGE blue_redcolormap.jpg
   *       @TR SEISMIC        @TD @IMAGE seismicColorMap.jpg
   *       @TR BLUE_WHITE_RED @TD @IMAGE blue_white_redcolormap.jpg
   *       @TR INTENSITY      @TD @IMAGE intensityColorMap.jpg
   *       @TR RAINBOW_TURBO  @TD @IMAGE turboColorMap.jpg
   *    @TABLE_END
   *
   * NOTE: The checkerboard pattern shows through where the color map alpha (opacity)
   * value is less than 1.0.
  */
  SoSFEnum predefColorMap;

  /**
  * Retrieves the interface to the color mapping object. 
  */
  const MiColorMapping<double,SbColorRGBA>* getColorMapping();

  /*----------------------------------------------------------------------------*/
  SoINTERNAL public:
  static void initClass() ;
  static void exitClass() ;

  typedef std::map<MoPredefinedColorMapping::PredefColorMapping,MdPredefinedColorMapping*>  PredefColorMappingMap;


  SoEXTENDER public:
  virtual void  doAction(SoAction *action) ;

protected:
  virtual ~MoPredefinedColorMapping() ;


  PredefColorMappingMap* m_predefColorMapping;

} ; 

#endif /* _MO_PREDEFINEDCOLORMAPPING_  */

