/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Oct 2011)
**=======================================================================*/

#ifndef  _MoStringSet_H
#define  _MoStringSet_H

#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
#include <MeshVizXLM/mapping/nodes/MoActionNode.h>
#include <MeshVizXLM/mesh/data/MiTypedDataSet.h>

/**
* @DTEXT Property node that stores any kind of string set.
*
* @ingroup MeshVizXLM_Mapping_Attributes
*
* @DESCRIPTION
*    This node adds a reference to an object implementing the MiStringSetI, MiStringSetIj or
*    MiStringSetIjk interface to the list of string sets in the traversal state.
*
*    Subsequent MoMeshCellShape instance will be able to use this string set.
*    During traversal of the scene graph, MoStringSet nodes are accumulated
*    into a list so that an extraction can use multiple string sets during the same
*    computation. 
*
*    Note:
*    - Any time the associated object MiStringSet is updated, touch() must also be called
*      to mark the node as modified. In addition, MiStringSet::getTimeStamp() must return a different
*      value than before to actually trigger a new rendering.
*
* @FILE_FORMAT_DEFAULT
*    StringSet {
*    @TABLE_FILE_FORMAT
*    @TABLE_END
*    }
*
* @ACTION_BEHAVIOR
*   Adds a string set to the string set list.  See MoStringSetElement.
*
* @SEE_ALSO
*   MoStringSetElement, MiStringSetI, MiStringSetIj, MiStringSetIjk
*
*/
class MESHVIZXLM_DMAP_API MoStringSet : public MoActionNode {

  SO_NODE_HEADER(MoStringSet) ;

 public:

  /**
   * Constructor.
   */
  MoStringSet() ;

   /**
   * Provides a common interface for setting any string set type (MiStringSetI,
   * MiStringSetIj or MiStringSetIjk) and marks the node as modified by calling touch().
   * The given StringSet is checked to ensure that a required type is provided. If not,
   * NULL is set instead.
   * @note When setting a new string set, the MiStringSet::getTimeStamp() must return a different
   * value than previously to actually take into account the change of string set.
   */
  virtual void setStringSet(const MiStringSet* StringSet);

  /**
  * Reset the associated string set to null (as if setStringSet was called with null).
  * Marks the node as modified by calling touch()
  */
  virtual void reset();

  /**
   * Gets the associated string set interface.
   * Use RTTI to find out which derived class it is.
   */
  virtual const MiStringSet* getStringSet();

  /*----------------------------------------------------------------------------*/
  SoINTERNAL public:
  static void initClass() ;
  static void exitClass() ;

  SoEXTENDER public:
  virtual void  doAction(SoAction *action) ;

protected:
  virtual ~MoStringSet() ;

  const MiStringSet* m_stringSet;

} ; 

#endif /* _MoStringSet_H  */

