#ifndef HIDDEN_FROM_DOC

/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

/*=======================================================================

***********************INTERNAL USE ONLY*********************************

*********************** DO NOT USE **************************************

**=======================================================================*/

#ifndef _MO_MESHBUMPSLICE_
#define _MO_MESHBUMPSLICE_

#include <MeshVizXLM/mapping/nodes/MoMeshPlaneSlice.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif


/**
* @DTEXT  INTERNAL USE ONLY, Rendering node that displays a bump slice from a plane of a volume mesh.
* 
* @ingroup MeshVizXLM_Mapping_Representation
* 
* @DESCRIPTION
*  A bump slice is based on an unstructured surface mesh defined by the intersection of 
*  an arbitrary plane with a volume mesh. This surface is rendered using a bump mapping 
*  method, using a depth parameter to compute the bump value.
*  The plane (an SbPlane) is defined by a direction vector and a distance from the origin.
*
*
* @FILE_FORMAT_DEFAULT
*    MeshBumpSlice {
*    @TABLE_FILE_FORMAT
*       @TR colorScalarSetId           @TD 0
*       @TR depth                      @TD 10.0
*       @TR parallel                   @TD TRUE
*       @TR plane                      @TD 0,0,1,0
*    @TABLE_END
*    }
*
* @SEE_ALSO
*  MoCellFilter, MoColorMapping, MoDrawStyle, MoMaterial, @BR
*  MiPlaneSliceExtractIjk,
*  MiPlaneSliceExtractUnstructured,
*  MiPlaneSliceExtractHexahedronIjk
* 
*/
class MESHVIZXLM_DMAP_API MoMeshBumpSlice : public MoMeshPlaneSlice {
  
  SO_NODE_HEADER( MoMeshBumpSlice );

public:

  /**
   * Constructor.
   */
  MoMeshBumpSlice();

  /**
   * The bump factor can be set to control bump mapping value.
   */
  SoSFFloat bumpFactor;

  /*----------------------------------------------------------------------------*/
  SoINTERNAL public:
  static void initClass() ;
  static void exitClass();


protected:
  /**
   * Destructor.
   */
  virtual ~MoMeshBumpSlice();

};

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHBUMPSLICE_ */



#endif //HIDDEN_FROM_DOC

