/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MIMESH_H
#define _MIMESH_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/MiAbstractMethodError.h>
#include <MeshVizXLM/mesh/topology/MiTopologyIjk.h>
#include <SoDeprecationRules.h>

/**
* @DTEXT Abstract mesh interface.
* 
* @ingroup MeshVizXLM_Mesh
* 
* @DESCRIPTION
*    This interface defines an abstract mesh. 
*    An abstract mesh organizes the domain by using a geometry and a
*    topology. Thus, any implementing class of MiMesh must implement
*    the methods getGeometry() and getTopology().
*    
*    @see MiLineMeshRegular
*    @see MiLineMeshCurvilinear
*    @see MiLineMeshUnstructured 
*    @see MiSurfaceMeshRegular
*    @see MiSurfaceMeshRectilinear
*    @see MiSurfaceMeshCurvilinear
*    @see MiSurfaceMeshUnstructured 
*    @see MiVolumeMeshRegular
*    @see MiVolumeMeshRectilinear
*    @see MiVolumeMeshCurvilinear
*    @see MiVolumeMeshUnstructured 
*    @see MiVolumeMeshHexahedronIjk
*    @see MiVolumeMeshVertexHexahedronIjk
*
*/
class MESHVIZXLM_EXTR_API MiMesh
{
public:
  virtual ~MiMesh() {}

  /**
  * Defines the dimensions in a one, two, or three-dimensional array.
  * 
  */

  enum Dimension {
    DIMENSION_I = 0, /* Dimension along the I indices */
    DIMENSION_J = 1, /* Dimension along the J indices */
    DIMENSION_K = 2  /* Dimension along the K indices */
  } ;

  /**
  * Outputs the mesh to a stream using the toStream protected method implemented in all derived classes.
  */
  friend std::ostream& operator<< (std::ostream& s, const MiMesh& mesh)
  {
    return mesh.toStream(s);
  }

protected: //PROTECTED_TO_DOCUMENT
  /**
  * Performs an output operation on a stream which is returned afterward.
  * This method is protected since only called by the output operator <<.
  * This method is not pure virtual and output by default the geometry and
  * topology of a mesh. Whenever a different output is needed, this method
  * can be implemented in the subclass to get a different output format.
  * No std::ostream& operator << needs to be defined in any subclass.
  * This allows you to benefit from the virtual inheritance when using the
  * output operator on an abstract class.
  */
  virtual std::ostream& toStream(std::ostream& s) const = 0;

};

#endif


