/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MIMESHREGULAR_H
#define _MIMESHREGULAR_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/MiMesh.h>
#include <MeshVizXLM/mesh/geometry/MiGeometryRegular.h>

/**
* @DTEXT Regular mesh abstract interface.
* 
* @ingroup MeshVizXLM_Mesh
* 
* @DESCRIPTION
*    This interface defines a regular mesh. 
*    A regular mesh has a geometry defined by a bounding box.
*    A regular mesh could be either a volume (a parallelepiped)
*    a surface (a rectangle) or a straight line.
* 
*    @see MiVolumeMeshRegular
*    @see MiLineMeshRegular
*    @see MiSurfaceMeshRegular
*
*/
class MESHVIZXLM_EXTR_API MiMeshRegular : virtual public MiMesh
{
public:
  /**
  * Returns the geometry of this mesh. 
  * A MiGeometryRegular represents a regular geometry fully defined by its min and max points.
  */
  virtual const MiGeometryRegular& getGeometry() const = 0;

};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


