/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MIMESHUNSTRUCTURED_H
#define _MIMESHUNSTRUCTURED_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <Inventor/STL/vector>

#include <MeshVizXLM/mesh/MiMesh.h>
#include <MeshVizXLM/mesh/geometry/MiGeometryI.h>


/**
* @DTEXT Unstructured mesh abstract interface.
* 
* @ingroup MeshVizXLM_Mesh
* 
* @DESCRIPTION
*    This interface defines a unstructured mesh. All unstructured meshes 
*    have a common geometry interface: getCoord(i).
*    An unstructured mesh can be either a volume, a surface or a line.
*
*    @see MiMeshUnstructuredI
*    @see MiVolumeMeshUnstructured
*    @see MiSurfaceMeshUnstructured
*    @see MiLineMeshUnstructured
*    @see MiLineMeshCurvilinear
*    @see MiVolumeMeshHexahedronIjk
* 
*/
class MESHVIZXLM_EXTR_API MiMeshUnstructured : virtual public MiMesh
{
public:
  /**
  * Returns the unstructured geometry of this mesh. 
  */
  virtual const MiGeometryI& getGeometry() const = 0;
};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


