/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MiVolumeMeshHexahedronIjk_H
#define _MiVolumeMeshHexahedronIjk_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/MiMeshUnstructured.h>
#include <MeshVizXLM/mesh/MiMeshIjk.h>
#include <MeshVizXLM/mesh/topology/MiHexahedronTopologyExplicitIjk.h>

/**
* @DTEXT IJK Hexahedron volume mesh abstract interface.
* 
* @ingroup MeshVizXLM_Mesh
* 
* @DESCRIPTION
*    An IJK Hexahedron Volume mesh is similar to an MiMeshCurvilinear except that adjacent cells 
*    may have different nodes (identified by node indices). 
*    This type of mesh can be used to define "faults", as in a petroleum reservoir model. 
*
*    Cells must be defined explicitly as a set of hexahedrons where each node is given independently of the adjacent cells.  
*
*  @see MiVolumeMeshCurvilinear for IJK meshes where adjacent cells share the same points.
*  @see MiVolumeMeshVertexHexahedronIjk for IJK meshes where hexahedrons are defined by explicit vertices.
*  @see MbVolumeMeshHexahedronIjk for a basic implementation.
* 
*/
class MESHVIZXLM_EXTR_API MiVolumeMeshHexahedronIjk : virtual public MiMeshUnstructured, virtual public MiMeshIjk
{
public:
  /**
  * Returns the topology of this mesh.
  */
  virtual const MiHexahedronTopologyExplicitIjk& getTopology() const = 0;

protected://PROTECTED_TO_DOCUMENT
  /**
  * @copydoc MiMesh::toStream(std::ostream& s) const
  */
  virtual std::ostream& toStream(std::ostream& s) const
  {
    s << "#MiVolumeMeshHexahedronIjk" << std::endl;
    s << getTopology() << std::endl;
    s << "#mesh geometry" << std::endl;
    for(size_t i=getTopology().getBeginNodeId(); i<getTopology().getEndNodeId(); ++i)
      s << i << ": " << getGeometry().getCoord(i) << std::endl;
    return s;
  }

};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


