/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MISURFACECELL_H
#define _MISURFACECELL_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/cell/MiCell.h>

/**
* @DTEXT  Defines an abstract cell of an unstructured surface mesh.
* 
* @ingroup MeshVizXLM_Mesh_Cell
* 
* @DESCRIPTION
*    A surface cell is a polygonal element that connects adjacent nodes of a surface mesh.
*
*    This class defines the method getSubTriangleNodesIndex(), which is only useful for 
*    non linear 2D cells. For linear 2D cells, the application only needs to implement
*    the methods defined in MiCell without overriding getSubTriangleNodesIndex().
*    
*    When the result of getSubTriangleNodesIndex() is > 0, the cell is considered a 
*    non linear cell. In that case, the given sub triangulation is used by various 
*    extractors (for instance MiTessellatedSurfaceExtract) and mesh representation classes
*    (for instance MoMeshSurface, MoMeshCellShape). 
*    Furthermore if an MiTessellator is given, each sub triangle is tessellated by the method 
*    MiTessellator::tessellateSurfaceCell().
* 
*    The  utility classes MxXXXCellExtract can be used to help the 
*    application implement the various methods of MiCell and MiSurfaceCell.
*    These classes provide static implementations of the necessary methods
*    for the most common linear and quadratic surface cells.
*
*   The implementation of all the methods of this class must be thread-safe because it might be called concurrently by multiple threads.
*   If the implementation can't be thread-safe, MeshViz XLM must be forced to use only 1 thread.
*   It can be done by calling MiMeshViz::init(1) or MoMeshViz::init(1) or setting the parallel argument
*   to false for each extractor instantiation. For instance by calling MiSkinExtractUnstructured::getNewInstance(&mesh, false);
*
*  @see MeXSurfaceCell
*  @see MiSurfaceTopologyExplicitI
*  @see MiTessellator
*  @see MxTriangleCellExtract, MxTriangle6CellExtract
*  @see MxQuadrangleCellExtract, MxQuadrangle8CellExtract, MxQuadrangle9CellExtract
*
*/
class MESHVIZXLM_EXTR_API MiSurfaceCell : public MiCell
{
public:
  /**
  * Get a decomposition of this surface cell into sub triangles.@BR
  *
  * This method must be overridden to correctly handle non-linear cells. 
  * For instance an implementation of this method for a quadratic 
  * triangle like the following one
  *   @IMAGE QuadraticTriangle6SubT.png Triangulation of a quadratic triangle.
  * should return 4, and triangleNodeIds = {0,3,5, 3,1,4, 3,4,5, 5,4,2}. 
  * (provided that getNodeIndex() follows this triangle node numbering).
  *
  * By default the method returns 0 and the argument triangleNodeIds is not modified.
  * It must not be overridden for a linear cell.
  *
  * @param[out] triangleNodeIds  sub-triangle node id (where: 0 <= triangleNodeIds[i] < getNumNodes() for each i).
  * @return the number of sub-triangles in this cell.
  */

  virtual size_t getSubTriangleNodesIndex(std::vector<size_t>& SO_UNUSED_PARAM(triangleNodeIds)) const 
  {
    return 0;
  }

};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif

