/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MIDATASETI_H
#define _MIDATASETI_H

#include <MeshVizXLM/MxMeshVizXLM.h>
#include <MeshVizXLM/mesh/data/MiTypedDataSet.h>

/**
* @DTEXT Generic data set interface for unstructured meshes.
* 
* @ingroup MeshVizXLM_Mesh_DataSets
* 
* @DESCRIPTION
*    A generic abstract template interface for a data set usable in any extract of an unstructured mesh.
* 
*/
template <typename _T>
class MiDataSetI : virtual public MiTypedDataSet<_T>
{
public:

  /**
  * Returns the i-th value of this set.
  */
  virtual _T get(size_t i) const = 0;

};

template class MESHVIZXLM_EXTR_API MiDataSetI<double>;

/**
* @ingroup MeshVizXLM_Mesh_DataSets
* Specialization for unstructured scalar sets containing double
*/
typedef MiDataSetI<double>  MiScalardSetI;

template class MESHVIZXLM_EXTR_API MiDataSetI<MbVec3d>;

/**
* @ingroup MeshVizXLM_Mesh_DataSets
* Specialization for unstructured vector sets containing MbVec3d
*/
typedef MiDataSetI<MbVec3d> MiVec3dSetI;

//! @cond Doxygen_Suppress
template class MESHVIZXLM_EXTR_API MiDataSetI<std::string>;
//! @endcond

/**
* @ingroup MeshVizXLM_Mesh_DataSets
* Specialization for unstructured string sets containing std::string
*/
typedef MiDataSetI<std::string> MiStringSetI;

#endif


