/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MITYPEDDATASET_H
#define _MITYPEDDATASET_H

#include <MeshVizXLM/mesh/data/MiDataSet.h>
#include <MeshVizXLM/MbVec3.h>

//-----------------------------------------------------------------------------
/**
* @DTEXT Generic typed data set interface.
* 
* @ingroup MeshVizXLM_Mesh_DataSets
* @DESCRIPTION
*    A generic abstract template interface for a typed data set.
*    Type _T must have an explicit constructor with a double variable.
* 
*/
template <typename _T>
class MiTypedDataSet: virtual public MiDataSet
{
};

template class MESHVIZXLM_EXTR_API MiTypedDataSet<double>;

/**
* @ingroup MeshVizXLM_Mesh_DataSets
* Specialization for scalar sets containing double
*/
typedef MiTypedDataSet<double>  MiScalardSet;

template class MESHVIZXLM_EXTR_API MiTypedDataSet<MbVec3d>;

/**
* @ingroup MeshVizXLM_Mesh_DataSets
* Specialization for vector sets containing MbVec3d
*/
typedef MiTypedDataSet<MbVec3d> MiVec3dSet;

/**
* @ingroup MeshVizXLM_Mesh_DataSets
* Specialization for string sets containing std::string
*/
typedef MiTypedDataSet<std::string> MiStringSet;

#endif


