/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MISURFACEGEOMETRYRECTILINEAR_H
#define _MISURFACEGEOMETRYRECTILINEAR_H

#include <MeshVizXLM/mesh/geometry/MiGeometry.h>

/**
* @DTEXT Generic rectilinear surface geometry.
* 
* @ingroup MeshVizXLM_Mesh_Geometry
* 
* @DESCRIPTION
*    This interface is used by MiSurfaceMeshRectilinear to access the geometry describing a rectilinear surface mesh.
*
*    @note
*    The existing representation nodes that use this type of 
*    geometry currently only handle geometry on the XY, YZ or ZX plane even 
*    though getNormal() could define any plane for this geometry.
* 
*/
class MESHVIZXLM_EXTR_API MiSurfaceGeometryRectilinear : virtual public MiGeometry
{
public:
  /**
  * Returns the i-th coordinate along the X axis.
  */
  virtual double getX(size_t i) const = 0;

  /**
  * Returns the j-th coordinate along the Y axis.
  */
  virtual double getY(size_t j) const = 0;

  /**
  * Returns the normal of the plane on which the rectilinear mesh is defined.
  * @return (0,0,1) by default (defining the plane XY).
  */
  virtual MbVec3d getNormal() const 
  {
    return MbVec3d(0,0,1);
  }

  /**
  * Returns the distance to the origin of the plane on which the rectilinear mesh is defined.
  * @return 0 by default.
  */
  virtual double getDistance() const 
  {
    return 0;
  }

};

#endif


