/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MITOPOLOGYEXPLICITI_H
#define _MITOPOLOGYEXPLICITI_H

#include <MeshVizXLM/mesh/topology/MiTopologyI.h>
#include <MeshVizXLM/mesh/cell/MiCell.h>

//-----------------------------------------------------------------------------
/**
* @DTEXT List of generic cells interface.
* 
* @ingroup MeshVizXLM_Mesh_Topology
* 
* @DESCRIPTION
*    A generic abstract interface for an unstructured explicit mesh topology. 
* 
*/
class MESHVIZXLM_EXTR_API MiTopologyExplicitI : virtual public MiTopologyI
{
public:

  /**
  * Returns a cell of this topology. The cell 
  * is identified by one id.
  * The implementation of this method must be thread-safe
  * because it might be called concurrently by multiple threads.
  */
  virtual const MiCell* getCell(size_t SO_UNUSED_PARAM(id)) const {return 0;} //= 0;

  /**
  * Returns the last node id + 1 used by this topology. This topology uses only 
  * node index in the interval [beginNodeId,EndNodeId[. Thus the maximum node
  * index used by the topology is getEndNodeId() - 1 and the number of 
  * nodes used by this topology is getEndNodeId() - getBeginNodeId().
  */
  virtual size_t getEndNodeId() const = 0;

  /**
  * Returns the first node id used by this topology. This topology uses only 
  * node index in the interval [beginNodeId,EndNodeId[. Thus the maximum node
  * index used by the topology is getEndNodeId() - 1 and the number of 
  * nodes used by this topology is getEndNodeId() - getBeginNodeId().
  * This default implementation returns 0.
  */
  virtual size_t getBeginNodeId() const { return 0; }

protected:

  virtual std::ostream& toStream(std::ostream& s) const
  {
    s << "# num cells" << std::endl;
    s << getNumCells() << std::endl;

    for(size_t i=0; i<getNumCells(); i++)
    {
      if (hasDeadCells() && isDead(i))
        s << "# cell #" << i << " (dead)" << std::endl;
      else
        s << "# cell #" << i << std::endl;

      s << *(getCell(i)) << std::endl;
    }
    return s;
  }

};


#endif


