/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MITOPOLOGYIJ_H
#define _MITOPOLOGYIJ_H

#include <MeshVizXLM/mesh/topology/MiTopology.h>

#include <Inventor/STL/sstream>
//-----------------------------------------------------------------------------
/**
* @DTEXT List of structured surface cells interface.
* 
* @ingroup MeshVizXLM_Mesh_Topology
* 
* @DESCRIPTION
*    A generic abstract interface for a structured implicit surface mesh topology. 
*    Cells are all implicitely defined as quadrangles so there is no need for specifying 
*    a list of cells. The number of cells on each dimension defines completely the topology.
*
*   The implementation of all the methods of this class must be thread-safe because it might be called concurrently by multiple threads.
*   If the implementation can't be thread-safe, MeshViz XLM must be forced to use only 1 thread.
*   It can be done by calling MiMeshViz::init(1) or MoMeshViz::init(1) or setting the parallel argument
*   to false for each extractor instantiation. For instance by calling MiSkinExtractUnstructured::getNewInstance(&mesh, false);
* 
*/
class MESHVIZXLM_EXTR_API MiTopologyIj : virtual public MiTopology
{
public:
  /**
  * Returns the number of cells on the first logical axis.
  */
  virtual size_t getNumCellsI() const = 0;

  /**
  * Returns the number of cells on the second logical axis.
  */
  virtual size_t getNumCellsJ() const = 0;

  /** 
  * Returns true if the cell of index (i,j) should be ignored.
  * This value is ignored if the hasDeadCell() method returns false.
  * The default implementation returns always false.
  * The implementation of this method must be thread-safe
  * because it might be called concurrently by multiple threads.
  * @param (i,j) the index of the cell to check
  */ 
  virtual bool isDead(size_t SO_UNUSED_PARAM(i), size_t SO_UNUSED_PARAM(j)) const{ return false ;};

protected://PROTECTED_TO_DOCUMENT
  /**
  * @copydoc MiMesh::toStream(std::ostream& s) const
  */ 
  virtual std::ostream& toStream(std::ostream& s) const
  { 
    s << "#Mesh topology Ij" << std::endl;
    s << "#Num Cells I" << std::endl;
    s << getNumCellsI() << std::endl;
    s << "#Num Cells J" << std::endl;
    s << getNumCellsJ() << std::endl;
    s << "#Has Dead Cells" << std::endl;
    s << hasDeadCells() << std::endl;
    if (hasDeadCells()) 
    {
      s << "#Dead Cells:" << std::endl;
      for (size_t i=0; i<getNumCellsI(); i++)
      {
        for (size_t j=0; j<getNumCellsJ(); j++)
        {
          if (isDead(i,j)) 
          {
            s << "deadCell " << i << " " << j << std::endl;
          }
        }
      }
    }

    return s;
  }

};


#endif

