/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MIVOLUMETOPOLOGYEXPLICITI_H
#define _MIVOLUMETOPOLOGYEXPLICITI_H

#include <MeshVizXLM/mesh/topology/MiTopologyExplicitI.h>
#include <MeshVizXLM/mesh/cell/MiVolumeCell.h>

//-----------------------------------------------------------------------------
/**
* @DTEXT List of volume cells interface.
* 
* @ingroup MeshVizXLM_Mesh_Topology
* 
* @DESCRIPTION
*    A generic abstract interface for an unstructured explicit volume mesh topology. 
* 
*/
class MESHVIZXLM_EXTR_API MiVolumeTopologyExplicitI : public MiTopologyExplicitI
{
public:

  /**
  * Returns a cell of this topology. The cell 
  * is identified by one id.
  * The implementation of this method must be thread-safe
  * because it might be called concurrently by multiple threads.
  */
  virtual const MiVolumeCell* getCell(size_t id) const = 0;

protected:

  virtual std::ostream& toStream(std::ostream& s) const
  {
    s << "#Volume topology explicitI " << std::endl;
    return MiTopologyExplicitI::toStream(s);
  }
};


#endif


