@mainpage Overview


# What is Open Inventor?
   Open Inventor is an object-oriented toolkit that simplifies
   and abstracts the task of writing graphics programming into a set of easy to
   use objects. These objects range from low level data-centered objects such
   as Sphere, Camera, Material, Light, and Group, to high level objects for
   Mesh visualization and Volume Rendering. The
   foundation concept in Open Inventor is the "scene database" which defines
   the objects to be used in an application. When using Open Inventor, a
   programmer creates, edits, and composes these objects into hierarchical 3D
   scene graphs (i.e., database). A variety of fundamental application tasks
   such as rendering, picking, event handling, and file reading/writing are
   built-in operations of all objects in the database and thus are simple to
   invoke.

   Since Open Inventor is object-oriented (written in C++), it
   encourages programmers to extend the system by writing new objects. Open
   Inventor users have created a variety of new objects that are not included
   in the product, such as: Bezier surfaces, CSG objects, animation objects,
   special viewers, and many more.

   The release number version is used to define the product version in terms of date.
   For example : For example 2023.2.7 for the second version of OIV in 2023 and the 7th patch version.

# Rendering

   The rendering mechanism inside Open Inventor objects employs OpenGL. During
   rendering, each object automatically makes the proper, efficient calls to
   OpenGL. Since Open Inventor was designed specifically to use OpenGL for
   graphics rendering, it is highly optimized to take advantage of all OpenGL
   accelerators. Its optimized scene graph pipeline also allows the developer
   to target PC and low-end systems without hardware acceleration.

   Furthermore, Open Inventor rendering supports a caching scheme which
   automatically generates very fast renderings of the database without
   additional traversal overhead.

# Picking

   Picking is the computer graphics term for selecting shapes in a 3D scene.
   Picking can select shapes intersected by a ray (SoRayPickAction) or
   shapes partially or completely inside a screen region like a "lasso"
   (SoExtSelection). Ray picking is typically used to detect what shape(s)
   are currently underneath the cursor.
   Open Inventor picking is very efficient and automatically uses cached
   bounding boxes to avoid traversing portions of the scene graph (culling).
   In some cases, Open Inventor uses the GPU to accelerate picking.
   Picking returns a variety of 3D information and detail about
   what objects were picked. A sorted list of picked objects and corresponding
   information is returned to the programmer. Picking is fast enough that programs
   can perform 3D locate highlighting as the mouse moves across a 3D window.

# Interaction, Events, and Devices

   Inventor defines an event model for writing 3D interaction. This model is
   window system independent. It is quite easy to use and makes 3D direct
   manipulation programming possible. Open Inventor includes a variety of
   interactive 3D objects and tools for writing interactive objects, such as:
   Manipulators, Draggers, and Projectors. The flexible event model encourages
   programmers to extend the system to support new devices and event types.
   Events include keyboard events, mouse events, touch events and gestures,
   and even tracked input device events for virtual/augmented reality applications.

# File Formats

   The Open Inventor 3D File Format is a de-facto standard for 3D data. The format
   supports both an ASCII and a compact binary format. The binary format is
   network-neutral and thus can be exported across machine boundaries.  Data files
   can be compressed to further reduce their size.

# Extender/internal methods and classes {#OivExtenderAPI}

 - **SoEXTENDER**: Many Inventor classes and member functions are labeled as EXTENDER in the C++ header files,
   which means they are available to programmers who wish to extend the toolkit.
   We strongly suggest to use this type of api only in the cases described in the Toolmaker guide
   such as creating a new class inherited from SoShape. See
   [Open Inventor Toolmaker](https://developer.openinventor.com/UserGuides/2023.1/Inventor_Toolmaker/index.html).

   The extender api are located in a SoEXTENDER public section in the header files and are not
   visible in the reference manual although they can be used and seen with a public visibility
   from any C++ compiler. Some of extender methods are also marked by a custom tag EXTENDER_API.
   This has exactly the same meaning but that makes the api visible from the reference manual.

 - **SoINTERNAL**: Member functions and classes that are listed in the Open Inventor
   header files under "SoINTERNAL public" are not intended for public use. They are subject to change
   without notice and are not recommended for use in Open Inventor applications.

 - **Note**: The words *SoEXTENDER public*, *SoINTERNAL public*, and *protected*
   do not appear in the header files when viewed using this documention.
   To see the exact contents of the header files, view the header files directly.

# Preview Features {#OivPreviewFeatures}
 **Preview Features** are special features that may not be fully implemented, but already provide useful services.

 Preview Features are fully supported  and can be used in Open Inventor applications.
 Being tagged as a Preview Feature just means that the implementation is still subject to API changes and
 adjustments based on feedback from early adopters. Please be also aware that source compatibility might be
 broken regardless of the
 [Open Inventor compatibility changes policy](https://developer.openinventor.com/index.php/general-documentation/product-life-cycle)
 due to our commitment to bring needed changes to be sure the specifications of these Preview Features match
 the expectations of our customers.

# Icon Reference
     |                           |                                               |                                                 |
     |---------------------------|-----------------------------------------------|-------------------------------------------------|
     | <img src="Inventor.gif">  | <img src="extTGS.gif" width="37" height="16"> | @link Inventor Open Inventor extension @endlink |
     | <img src="MeshViz.gif">   | <img src="extMV.gif" width="37" height="16">  | @link MeshVizXLM MeshViz XLM extension @endlink |
     | <img src="VolumeViz.gif"> | <img src="extVV.gif" width="37" height="16">  | @link VolumeViz VolumeViz extension @endlink    |
     | <img src="RemoteViz.gif"> | <img src="extRV.gif" width="37" height="16">  | @link RemoteViz RemoteViz extension @endlink    |
     | <img src="HardCopy.gif">  | <img src="extHC.gif" width="37" height="16">  | @link HardCopy HardCopy extension @endlink      |


# Other Sources of Information

- On-line documentation (accessible from https://developer.openinventor.com/)
  It covers Open Inventor as well as its
  extensions -- MeshViz, HardCopy, VolumeViz, etc.
  It contains
  system requirements and installation instructions; release
  notes and lists of fixed bugs; a reference manual, a user's
  guide, and FAQs; as well as information about a variety of other topics
  including performance, redistribution packaging, and more.

- ReadMe files (clear text files accessible from OIVHOME/ReadMe/ *.txt)

- ReadMe1st.md which is the first file to read.

- Printed materials (out of print, but useful)
    - **The Inventor Mentor**, published by Addison-Wesley. This book describes how to write
      applications using the Open Inventor toolkit. This is an excellent book for new
      users of Open Inventor.
    - **The Inventor Toolmaker**, published by Addison-Wesley. For advanced programmers, this book
      describes how to create new Open Inventor classes, and how to customize existing classes.
    - **Open Inventor C++ Reference Manual**, published by Addison-Wesley. It is obsolete and should
      no longer be used as the reference documentation of Open Inventor API
      as it is too far from the existing version. The updated documentation of the API is available
      online at https://developer.openinventor.com/index.php/reference-manuals/ and offline
      in the installed package ($OIVHOME/doc/ReferenceManual.html)

- Other
    - Open Inventor technical support (if your license has technical support)
    - Sample programs and sample Open Inventor data files (*.iv) - These are an
      excellent source of information about using Open Inventor. Example programs
      are provided to demonstrate almost every signficant feature of Open Inventor.
    - Open Inventor web site (https://www.openinventor.com) - May provide additional helpful information.

# Third Party Software

 Open Inventor uses libraries from a number of third party software providers,
 including some open source libraries. To the best of our knowledge, all third party libraries
 are used in accordance with the terms of their appropriate license agreement (if any). See the
 topic **3RD PARTY SOFT**. on-line documentation (accessible from $OIVHOME/doc/index.htm)
 for information on the version numbers as well as copyright notices, licenses, etc., as requested
 by the various third parties.


# Generated with...

This documentation is automatically generated from the public
header files using doxygen: (https://www.doxygen.org/index.html)