/*=======================================================================
*** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
***                                                                                ***
***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
***                                                                                ***
***                        RESTRICTED RIGHTS LEGEND                                ***
***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
***                                                                                ***
***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
***                        BORDEAUX, FRANCE                                        ***
***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#ifndef  _REMOTEVIZ_CLIENT_
#define  _REMOTEVIZ_CLIENT_

#include <Inventor/sys/port.h>
#include <RemoteViz/Clients/nodes/LibHelper.h>

/**
 * @RVEXT Initializes the RemoteVizClient module database.
 *
 * @ingroup RemoteViz
 *
 * @DESCRIPTION
 *   It is used only for initializing the SoRemoteVizClient node.
 *
 * @SEE_ALSO
 *    SoRemoteVizClient
 *
 * [OIV-WRAPPER-NO-WRAP]
 *
 */
class RVCLIENT_API RemoteVizClient
{

public:
  /**
   * Initializes the RemoteViz module database. This must be called before the
   * construction of any RemoteViz nodes.
   * 
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void		init();

  /** 
   * Shuts down the RemoteViz module, which includes freeing any
   * internal static memory that it allocated. 
   * 
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void finish();

  /**
   * Returns TRUE if module is currently initialized.
   * [OIV-WRAPPER-NO-WRAP]
   */
  static bool isInitialized();

private:
   static int s_initRefCount;          // module ref counter
};

#endif // _REMOTEVIZ_CLIENT_
