/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#pragma once

#include <Inventor/sys/port.h>
#include <RemoteViz/Rendering/LibHelper.h>

#include <string>
#include <memory>


namespace RemoteViz
{
  namespace Rendering
  {

    class ConnectionParametersImpl;

    /**
     * @RVEXT
     *
     * @ingroup RemoteViz
     *
     * @DESCRIPTION
     *  Field-value pairs included in the URL when the client requested a connection. 
     *  See RemoteVizRenderArea#connectTo and SoRemoteVizClient#connectionParameters.
     *
     *  A ConnectionParameters object is passed to ServiceListener#onPendingCreateRenderArea
     *  and to ServiceListener#onPendingShareRenderArea.
     *
     *  The application can also query this object from a Connection object.
     *  The Connection object can obtained in, e.g., RenderAreaListener::onInitializedConnection().
     *
     * [OIVJAVA-WRAPPER-CLASS SHARED_POINTER_USE]
     * [OIVNET-WRAPPER-CLASS AUTO_PROPERTY,SHARED_POINTER_USE]
     */
    class RENDERSERVICE_API ConnectionParameters {

      /*! \cond PRIVATE */
      friend class ConnectionImpl;
      /*! \endcond */

    public:

      /**
       *  Gets the number of parameters
       *
       *  \return the number of parameters
       */
      unsigned int getNumParameters() const;
      /**
       *  Gets the value of a parameter associated with an index.
       *
       *  \param index : the parameter index. Range id [0..getNumParameters - 1]
       *
       *  \return the value if the index exists, otherwise returns an empty string.
       */
      const std::string& getValue(int index) const;
      /**
       *  Gets the value of a parameter associated with a key.
       *
       *  \param key : the key
       *
       *  \return the value if the key exists, otherwise returns an empty string.
       */
      const std::string& getValue(const std::string& key) const;
      /**
       *  Gets the key associated with an index.
       *
       *  \param index : the parameter index. Range id [0..getNumParameters - 1]
       *
       *  \return the key if the index exists, otherwise returns an empty string.
       */
      const std::string& getKey(int index) const;
      /**
       *  Gets the index associated with a key.
       *
       *  \return the index if the key exists, otherwise returns -1.
       */
      int getIndex(const std::string& key) const;

    protected:
      /*! \cond PRIVATE */
      std::shared_ptr<ConnectionParametersImpl> getImpl() const;
      /*! \endcond */

    private:
      /** Pointer to implementation */
      std::shared_ptr<ConnectionParametersImpl> pImpl;

      /** Constructor */
      ConnectionParameters(const std::string& url);

      /** Deleted constructors */
      ConnectionParameters(const ConnectionParameters&) = delete;
      ConnectionParameters& operator= (const ConnectionParameters&) = delete;

    };

  }
}
