/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#pragma once

#include <Inventor/sys/port.h>
#include <string>
#include <memory>

namespace RemoteViz
{
  namespace Rendering
  {
    class EncodedFrameImpl;

    /**
     * @RVEXT
     *
     * @ingroup RemoteViz
     *
     * @DESCRIPTION
     *  This class provides the features of an encoded frame that is sent to the client.
     *
     * [OIVJAVA-WRAPPER-CLASS BASIC_TYPE{false}]
     * [OIVNET-WRAPPER-CLASS AUTO_PROPERTY]
     */
    class RENDERSERVICE_API EncodedFrame
    {

      /*! \cond PRIVATE */
      friend class ConnectionImpl;
      /*! \endcond */

    public:

      /**
       * Encoding format
       */
      enum EncodingFormat {
        JPEG,
        PNG,
        H264,
        VP9
      };

      /**
       *  Constructor.
       */
      EncodedFrame();

      /**
       *  Copy constructor
       */
      EncodedFrame(const EncodedFrame& obj);

      /**
       *  Copy assignment operator
       */
      EncodedFrame& operator=(const EncodedFrame& obj);

      /**
       *  Destructor
       */
      ~EncodedFrame();

      /**
       *  Gets the frame buffer size in bytes
       *  \return the buffer size of the encoded frame.
       */
      size_t getBufferSize() const;

      /**
       * Gets the frame encoding format
       * \return the encoding format of the encoded frame.
       */
      EncodingFormat getEncodingFormat() const;

      /**
       * Gets the frame id
       * \return the frame id of the encoded frame.
       */
      size_t getId() const;

      /**
       * Returns if the frame is lossless
       * \return true if the frame is lossless
       */
      bool isLossless() const;

      /**
       * Returns if an user interaction is in progress when the frame has been encoded.
       * If the frame is interactive, the frame has been encoded with the interactive frame encoder and a quality adapted to the network bandwidth.\n
       * Otherwise (the frame is still), the frame has been encoded with the still frame encoder and the best available quality.\n
       * \return true if the frame is interactive
       */
      bool isInteractive() const;

      /**
       * Gets the frame message
       * \return the message joint with the encoded frame.
       */
      std::string getMessage() const;

    protected:
      /*! \cond PRIVATE */
      /** Returns a pointer to implementation */
      std::shared_ptr<EncodedFrameImpl> getImpl() const;
      /*! \endcond */

    private:

      /** Pointer to implementation */
      std::shared_ptr<EncodedFrameImpl> pImpl;

    };
  }
}
