/*=======================================================================
*** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
***                                                                                ***
***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
***                                                                                ***
***                        RESTRICTED RIGHTS LEGEND                                ***
***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
***                                                                                ***
***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
***                        BORDEAUX, FRANCE                                        ***
***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#pragma once

#include <Inventor/sys/port.h>
#include <RemoteViz/Rendering/LibHelper.h>

#include <memory>
#include <string>

namespace RemoteViz
{
  namespace Rendering
  {
    class HTTPHeadersImpl;

    /**
    * @RVEXT
    *
    * @ingroup RemoteViz
    *
    * @DESCRIPTION
    * This class represents the header configuration options for an HTTP request and response.
    *
    * Note that HTTPHeaders treats header names in a case-insensitive manner.
    *
    * [OIVJAVA-WRAPPER-CLASS BASIC_TYPE{false}]
    * [OIVNET-WRAPPER-CLASS AUTO_PROPERTY]
    */
    class RENDERSERVICE_API HTTPHeaders
    {
    public:

      /**
       * Creates an empty object
       */
      HTTPHeaders();

      /**
       *  Copy constructor
       */
      HTTPHeaders(const HTTPHeaders& obj);

      /**
       *  Copy assignment operator
       */
      HTTPHeaders& operator=(const HTTPHeaders& obj);

      /**
       * Destructor
       */
      ~HTTPHeaders();

      /**
       * Adds the given header value under the given name.
       * If a header already exists with the given name, its value will be overwritten.
       *
       * \param name the header to add to the collection.
       *
       * \param value the content of the header.
       */
      void add(const std::string& name, const std::string& value);

      /**
       * Removes the header value under the given name.
       *
       * \param name the name of the header to remove from the collection.
       */
      void remove(const std::string& name);

      /**
       * Removes all headers.
       */
      void clear();

      /**
       * Gets the number of HTTP headers.
       *
       * \return number of HTTP headers.
       */
      size_t count() const;

      /**
       * Determines if the headers collection contains a header of the specified name, with any value.
       *
       * param name the name of the header to check
       *
       * \return true if the given header exists.
       */
      bool exists(const std::string& name) const;

      /**
       * Retrieves the value of a given header.
       *
       * \param name the name of the header to check
       *
       * \return the value of the given header name or an empty string if the given header does not exist.
       */
      const std::string& getValue(const std::string& name) const;

      /**
       * Retrieves the header name from a collection index.
       *
       * \param index index of the header to retrieve
       *
       * \return the header name at the given index or an empty string if the given index does not exist.
       */
      const std::string& getNameAt(size_t index) const;

    protected:
      /*! \cond PRIVATE */
      /** Returns a pointer to implementation */
      std::shared_ptr<HTTPHeadersImpl> getImpl() const;
      /*! \endcond */

    private:
      /** Pointer to implementation */
      std::shared_ptr<HTTPHeadersImpl> pImpl;
    };

  }
}
