/*=======================================================================
*** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
***                                                                                ***
***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
***                                                                                ***
***                        RESTRICTED RIGHTS LEGEND                                ***
***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
***                                                                                ***
***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
***                        BORDEAUX, FRANCE                                        ***
***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#pragma once

#include <Inventor/sys/port.h>
#include <RemoteViz/Rendering/LibHelper.h>

#include <memory>
#include <string>

namespace RemoteViz
{
  namespace Rendering
  {
    class UriImpl;

    /**
    * @RVEXT
    *
    * @ingroup RemoteViz
    *
    * @DESCRIPTION
    * This class represents a Uniform Resource Identifier (URI). 
    *
    * A Uniform Resource Identifier (URI) is a compact sequence of
    * characters that identifies an abstract or physical resource.  
    *
    * [OIVJAVA-WRAPPER-CLASS BASIC_TYPE{false}]
    * [OIVNET-WRAPPER-CLASS AUTO_PROPERTY]
    */
    class RENDERSERVICE_API Uri
    {
    public:

      /**
       * Creates an Uri object
       */
      Uri(const std::string& uri);

      /**
       *  Copy constructor
       */
      Uri(const Uri& obj);

      /**
       *  Copy assignment operator
       */
      Uri& operator=(const Uri& obj);

      /**
       * Destructor
       */
      ~Uri();

      /**
       * Returns the scheme name for this URI.
       */
      const std::string& getScheme() const;

      /**
       * Returns the Domain Name System (DNS) host name or IP address and the port number for a server.
       */
      const std::string& getAuthority() const;

      /**
       * Returns the port number of this URI.
       */
      const std::string& getPort() const;

      /**
       *  Returns the path of the URI.
       */
      const std::string& getPath() const;

      /**
       * Returns any query information included in the specified URI.
       */
      const std::string& getQuery() const;

      /**
       * Returns the Path and Query properties separated by a question mark (?).
       */
      const std::string& getPathAndQuery() const;

      /**
       * Returns whether the Uri instance is absolute.
       */
      bool isAbsolute() const;

    protected:
      /*! \cond PRIVATE */
      /** Returns a pointer to implementation */
      std::shared_ptr<UriImpl> getImpl() const;
      /*! \endcond */

    private:

      /**
      * Deleted constructor
      */
      Uri() = delete;

      /** Pointer to implementation */
      std::shared_ptr<UriImpl> pImpl;
    };

  }
}
