/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Mar 2007)
**=======================================================================*/


#ifndef SO_SCALEVIZ_H
#define SO_SCALEVIZ_H

#include <Inventor/SbString.h>

typedef void* scaleviz_ptr;
typedef int32_t ScStreamSize;
typedef int32_t ScStreamType;
typedef int64_t ScMemObjStreamPtr;

#include <ScaleViz/SoScaleVizLibName.h>
#if defined(_WIN32)
#  ifndef ScaleViz_EXPORTS
#    ifndef OIV_DISABLE_AUTOLINK
#      pragma comment(lib,__SCALEVIZLIB)
#    endif
#  endif
#endif

class SoScaleVizConfig;

#include <Inventor/SoModule.h>
SO_MODULE_HEADER( SoScaleViz, __SCALEVIZDLL )

/**
 *
 * @SCVEXT ScaleViz initialization
 * 
 * @ingroup ScaleViz
 * 
 * @DESCRIPTION
 *
 * This class performs ScaleViz initialization.
 *
 */
class SCALEVIZ_API SoScaleViz
{

public:

  enum CompositingType {
    NONE  = 0,
    TILE  = 1 << 0,
    DEPTH = 1 << 1
  };

public:

  /**
   * Returns a character string identifying the name of the extension.
   */
  static SbString getProductName();

#if SoDEPRECATED_BEGIN(2023200)
  /**
   * Returns a character string identifying the version of the extension.
   */
  SoDEPRECATED_METHOD(2023.2, "This method should no longer be used. Use SoLicensesInfo::getVersion() method instead.")
  static const char *getVersion();
#endif /** @DEPRECATED_END */

#if SoDEPRECATED_BEGIN(2023200)
  /**
   * Returns a character string identifying the version of the extension.
   * ("major.minor").
   */
  SoDEPRECATED_METHOD(2023.2, "This method should no longer be used. Use SoLicensesInfo::getVersion() method instead.")
  static const char *getCompactVersion();
#endif /** @DEPRECATED_END */

  /**
   * Returns the compilation date of the current version.
   */
  static const char *getCompilationDate();

  /**
   * Initializes ScaleViz. Initialization is handled automatically
   * by Open Inventor. It is not necessary to call this method in
   * a user application.
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void init();

  /** 
   * Shuts down the ScaleViz module, which includes freeing any
   * internal static memory that it allocated. 
   * Finish methods must be called in the reverse order of the init method calls: 
   * \code
   *    SoScaleViz::finish(); 
   *    SoXt::finish(); 
   *    ... \endcode
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void finish();
  
  /**
   * Returns TRUE if SoScaleViz::init has been called.
   * [OIV-WRAPPER-NO-WRAP]
   */
  static bool isInitialized();

  /**
   * Returns TRUE if using a Vnc configuration.
   */  
  static bool isUsingVnc();

  /**
   * Returns the compositing type currently used (if any).
   */
  static CompositingType isComposing();
  
  /**
   * Returns TRUE if using ScaleViz cluster mode.
   */
  static bool isRunningCluster();
  
  /**
   * Returns TRUE if running on part of an OIRU.
   */
  static bool isOiru();

  /**
   * Indicates which function is responsible for registering classes
   * of the given module.
   */
  typedef void InitCallback(void);

  /**
   * Returns the number of render units currently running.
   */
  static int getNumRenderUnits();

  /**
   * Returns TRUE if a redraw is done on the application side.
   */
  static bool isLocalRedraw();

  /**
   * Adds a new configuration to ScaleViz. Returns false if the configuration
   * is not valid (e.g., if there are syntax errors). 
   */
  static bool addConfig( SoScaleVizConfig* config );

  /**
   * Adds a new configuration to ScaleViz. Returns false if the configuration
   * is not valid (e.g., if there are syntax errors). 
   *
   * @UNICODE_WARNING
   */
  SoNONUNICODE static bool addConfigFromFile( const char* filename );

  /**
   * Adds a new configuration to ScaleViz. Returns false if the configuration
   * is not valid (e.g., if there are syntax errors). 
   */
  static bool addConfigFromFile( const SbString& filename );

  /**
   * Removes configuration from ScaleViz. Returns true if the configuration
   * has been successfully removed.
   */
  static bool removeConfig( SoScaleVizConfig* config );
  
  /**
   * Remove all configurations defined using the passed filename.
   * Returns the number of removed configurations.
   */
  static int32_t removeConfigFromFile( const char* filename );

  /**
   * Specifies the ScaleViz configuration to launch at connection time.
   * Returns false if the specified configuration is not available or cannot be selected.
   */
  static bool setSelectedConfiguration( SoScaleVizConfig* config );

  /**
   * Specifies the ScaleViz configuration to launch at connection time.
   * Returns false if the specified configuration is not available or cannot be selected.
   */
  static bool setSelectedConfiguration( SbString& configName );

  /**
   * Returns the currently selected configuration.
   */
  static SoScaleVizConfig* getSelectedConfiguration();

  /**
   * Returns the i-th configuration from the list of registered configurations.
   */
  static SoScaleVizConfig* getConfiguration( const int32_t index );

  /**
   * Returns the number of registered configurations.
   */
  static int32_t getConfigurationCount();

  /**
   * Launches the connection process using the active configuration.
   */
  static void connect();

  /**
   * Disconnects from the cluster.
   */
  static void disconnect();

  /**
   * Returns true when ScaleViz is connected to the cluster.
   */
  static bool isConnected();

  /**
   * Returns true if remote rendering is enabled (see OIV_REMOTE_ENABLE)
   */
  static bool isRemoteEnabled();

SoINTERNAL public:
  static void setRunningQt(const bool b, int qtVersion = 0);

  /** Returns TRUE if current running configuration is multipipe. */
  static bool isRunningMultipipe();
  static bool isRunningART();

private:
  static int s_initRefCount;
};

inline bool
SoScaleViz::isRunningCluster()
{
  return isConnected();
}

#endif // SO_SCALEVIZ_H

/**/


