/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Jun 2007)
**=======================================================================*/


#ifndef  SO_SCALEVIZ_CONFIG_H
#define  SO_SCALEVIZ_CONFIG_H

#include <Inventor/nodes/SoGroup.h>
#include <Inventor/fields/SoSFString.h>

/** 
 * @SCVEXT Defines a ScaleViz configuration.
 * 
 * @ingroup ScaleVizNodes
 * 
 * @DESCRIPTION
 * 
* 
 * @FILE_FORMAT_DEFAULT
 *    ScaleVizConfig {
 *    @TABLE_FILE_FORMAT
 *       @TR name           @TD ""
 *    @TABLE_END
 *    }
 *
 * 
 */
class SCALEVIZ_API SoScaleVizConfig : public SoGroup
{
  SO_NODE_HEADER(SoScaleVizConfig);

public:

  /**
   * Name of the configuration.
   */
  SoSFString name;

  /**
   * Creates an SoScaleVizConfig node with default settings.
   */
  SoScaleVizConfig();

SoINTERNAL public:
  static void initClass();
  static void exitClass();

SoEXTENDER public:
  /** @copydoc SoNode::write */
  virtual void write(SoWriteAction* action);

protected:
  virtual ~SoScaleVizConfig();

};

#endif // SO_SCALEVIZ_CONFIG_H

/**/


