/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Jan 2008)
**=======================================================================*/


/** 
 * @SCVEXT Inherit your rendering areas to take benefits of ScaleViz.
 * 
 * @ingroup ScaleVizViewers
 * 
 * @DESCRIPTION
 *
 *
 */

#ifndef SO_GUI_BASE_H
#define SO_GUI_BASE_H

#include <Inventor/fields/SoFieldContainer.h>
#include <Inventor/fields/SoSFFieldContainer.h>
#include <Inventor/fields/SoMFInt32.h>
#include <Inventor/fields/SoSubFieldContainer.h>
#include <Inventor/fields/SoSFBool.h>
#include <Inventor/fields/SoSFVec2i32.h>
#include <Inventor/fields/SoSFColor.h>
#include <Inventor/STL/set>
#include <Inventor/SoSceneManager.h>
#include <Inventor/antialiasing/SiAntialiasingEventListener.h>

#if defined(_WIN32)
#pragma warning( push )
#pragma warning( disable: 4251 )
#endif

SoINTERNAL class SCALEVIZ_API SoGuiBase : public SoFieldContainer
{
  SO_FIELDCONTAINER_ABSTRACT_HEADER(SoGuiBase);

SoINTERNAL public:

  SoSFBool visible;
  SoSFFieldContainer remoteServer;
	SoSFVec2i32 size;
  SoSFColor vncColorMask;

  virtual void signalRedraw() {};
  virtual void cleanRedraw() {};
  virtual SoSceneManager* getSceneManager() const { return NULL; };
  virtual void* getNormalWindow() { return 0; };

  // Returns the list of existing viewers.
  typedef std::set<SoGuiBase*> t_viewerList;
  static t_viewerList m_viewerList;

  static t_viewerList* getViewerList() { return &m_viewerList; };

  // return the remote render server from field remoteServer.
  SoFieldContainer* getRemote() const;
  void setRemote( SoFieldContainer* remote );

  // return true if we need to do local rendering
  SbBool isLocalRedraw() const;

  inline const SbString &getRemoteName() const;

  void changeVncColorMask(SbColor& color);

  virtual SbBool bindNormalContext() =0;
  virtual SbBool unbindNormalContext() =0;

  bool shouldUpdate();
  void setShouldUpdate( bool );

protected:

  /** Constructor. */
  SoGuiBase();

  /** Destructor. */
  virtual ~SoGuiBase();

  SbString m_remoteName;

private:
  bool m_shouldUpdate;
};

inline SoFieldContainer*
SoGuiBase::getRemote() const
{
  return (SoFieldContainer*)(remoteServer.getValue());
}

const SbString& SoGuiBase::getRemoteName() const
{
  return m_remoteName;
}

template<class T> class SoGuiAntialiasingListener : public SiAntialiasingEventListener
{
public:
  SoGuiAntialiasingListener(T* widget)
    :m_widget(widget)
  {}

  ~SoGuiAntialiasingListener()
  {}

  bool onAntialiasingSwitch(const SoSceneManager::AntialiasingMode& mode, const float& quality, const SoAntialiasingParameters* parameters)
  {
    return m_widget->onAntialiasingSwitch(mode, quality, parameters);
  }

private:
  T* m_widget;
};


#if defined(_WIN32)
#pragma warning( pop )
#endif

#endif // SO_GUI_BASE_H

/**/

