/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _SO_DEBUG_
#define _SO_DEBUG_

#include <Inventor/SbBasic.h>

class SoBase;
class SoNode;
class SoField;

//
// List of environment variables for tracing:
//
//   IV_DEBUG_BUFLEN   : Number of lines RTPrintf saves up before
//	dumping out.  Defaults to 100, set to 1 to get it to dump
//	after every line.
//   IV_DEBUG_SENSORS  : will print out info as sensors are
//	triggered/etc
//   IV_DEBUG_CACHES   : print out info on cache validity, etc.
//   IV_DEBUG_CACHELIST : print out info on Separator render caches.
//

SoINTERNAL class INVENTOR_API SoDebug {
  public:
    // Returns value of environment variable; faster than getenv()
    // because the environment variables are stored in a dictionary.
    static const char *	GetEnv(const char *envVar);

    // Prints into an internal buffer that is emptied every once in a
    // while.  Useful when doing the print right away screws up the
    // timing of the thing you're trying to debug.
    static void		RTPrintf(const char *formatString ...);

    // Assign the given pointer a name.  The passed name string isn't
    // copied; if it changes, the name of the pointer changes.
    static void		NamePtr(const char *name, void *ptr);

    // Return the name of the given pointer (returns "<noName>" if not
    // named previously with NamePtr).
    static const char *	PtrName(void *ptr);

    // Applies an SoWriteAction to the graph rooted by the given node.
    // The results go to stdout.  Very useful when called from within
    // a debugger!
    static void		write(SoNode *node);

    // Applies an SoWriteAction to the graph rooted by the given node,
    // writing to given file, or /tmp/debug.iv if filename is NULL.
    static void		writeFile(SoNode *node, const char *filename);

    // Applies an SoWriteAction to the container of the given field.
    // The results go to stdout.  Very useful when called from within
    // a debugger!
    static void		writeField(SoField *node);

    // Writes the name of the given object to stdout.  Very useful
    // when called from within a debugger!
    static void		printName(SoBase *base);
};

#endif /* _SO_DEBUG_ */


