/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Apr 2003)
**=======================================================================*/

#ifndef  _SO_LDM_VVIZ_CONVERTER_
#define  _SO_LDM_VVIZ_CONVERTER_

#include <LDM/converters/SoBaseLDMConverter.h>
class SoVolumeReader;

#ifdef _WIN32
#pragma warning( push )
#pragma warning(disable:4251)
#endif

/**
* @VREXT Class for converting volume data sets into the LDM format.
*
* @ingroup VolumeVizConverters
*
* @DESCRIPTION
*
* This class converts existing volume data sets into the LDM (Large Data Management)
* format.
* 
* The LDM converter classes provide many powerful features.  Information common 
* to all converter classes is documented in SoConverter, including:
* - Command line parsing for easy creation of stand-alone converter programs.
* - Checkpoint and restart for interrupted conversions.
* - Multiple subsampling algorithms for creating low resolution tiles.
* - Automatic loading of any supported data format (see SoVolumeData).
* - Conversion of any data format by providing a custom reader (see SoVolumeReader).
* - Optional data compression to reduce disk space.
* - Optional data type conversion, e.g. float to byte.
*
* You can subclass from SoVolumeConverter to use a custom volume reader, 
* provide a custom subsampling method, etc.  A custom volume reader can be used to
* convert almost any data format into LDM format.  To use a custom volume reader,
* derive a new class from SoVolumeReader and override the getReader() method.
* To use a custom subsampling method override the sampleTile method. 
* See for example $OIVHOME/examples/source/VolumeViz/Converters/custom/LDMConverterExample.cxx.
*
* @SEE_ALSO
*    SoConverter,
*    SoBaseLDMConverter,
*    SoVolumeReader
* [OIV-WRAPPER-CLASS CUSTOM_CODE]
*/
class VOLUMEVIZ_API SoVolumeConverter : public SoBaseLDMConverter
{

public:
 /**
   * Constructor.
   */
  SoVolumeConverter();


private:
  virtual void instanciateReader(SoConverter::ConverterError& error);

};

#if defined(_WIN32)
#pragma warning( pop )
#pragma warning(disable:4251)
#endif

#endif // _SO_LDM_VVIZ_CONVERTER_


