/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : J.SALLANNE (Sep 2014)
**=======================================================================*/

#ifndef _SO_FENCE_SLICE_DETAIL_
#define _SO_FENCE_SLICE_DETAIL_

#include <Inventor/details/SoSubDetail.h>
#include <VolumeViz/details/SoVolumeDetail.h>

SO_PIMPL_PUBLIC_DECLARATION(SoFenceSliceDetail)

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoFenceSliceDetail
//
//  Detail about an SoFenceSlice node.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * @VREXT Stores detail information about a picked voxel or pick ray in a data volume.
 *
 * @ingroup VolumeVizDetails
 *
 * @DESCRIPTION
 *   A successful pick operation returns an SoPickedPoint object. If the picked
 *   geometry is an SoFenceSlice node, use the @B getDetail @b method and cast
 *   the result to this class to get extra information about the pick.
 *
 *   SoFenceSliceDetail returns information about the first (closest)
 *   non-transparent voxel along the pick ray and/or information about all the voxels
 *   intersected by the pick ray (called a profile).
 *
 *   For the first non-transparent voxel (if any) on the pick ray, it returns the
 *   XYZ position in 3D space, IJK location in voxels and the data value.
 *   See method #getFirstNonTransparentValue().
 *
 *   For the profile defined by all the intersected voxels, it returns:
 *
 *   - Profile position in object space (two XYZ points).
 *     @BR See method #getProfileObjectPos().
 *
 *   - Profile location in the data volume (two IJK indices).
 *     @BR See method #getProfileDataPos().
 *
 *   - Number of values along the profile.
 *     @BR See method #getProfileDataPos().
 *
 *   - For each value along the profile: the voxel value and its corresponding IJK location.
 *     @BR See method #getProfileValue().
 *
 * @B Notes: @b
 *   - To get information about all voxels intersected by the ray, the application @a must set the
 *     @B pickAll @b flag of the SoRayPickAction to TRUE. (This is different than the behavior
 *     of SoVolumeRenderDetail.
 *
 * @B Limitations:@b
 *   - If multiple volumes are being combined under an SoMultiDataSeparator,
 *     the detail class only returns values for the first volume in the scene graph.
 *
 * @SEE_ALSO
 *    SoDetail,
 *    SoVolumeDetail,
 *    SoFenceSlice
 *
 *
 */
class VOLUMEVIZ_API SoFenceSliceDetail : public SoVolumeDetail {

  SO_DETAIL_HEADER(SoFenceSliceDetail);
  SO_PIMPL_PUBLIC_HEADER(SoFenceSliceDetail);

 public:
  /**
   * Constructor.
   */
  SoFenceSliceDetail();
  /**
   * Destructor.
   */
  virtual ~SoFenceSliceDetail();

  /** @copydoc SoVolumeDetail::copy() */
  virtual SoDetail* copy() const;

 SoINTERNAL public:
  static void initClass();
  static void exitClass();

  void setObjectPosVec(const std::vector<SbVec3f>& vec);

private:
  /** Copy constructor */
  SoFenceSliceDetail(const SoFenceSliceDetail& detail);

};

#endif /* _SO_FENCE_SLICE_DETAIL_ */


