/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : P. ESTRADE (Dec 2000)
** Modified by : T.DUFOUR (MMM yyyy)
**=======================================================================*/

#ifndef _SO_OBLIQUE_SLICE_DETAIL_
#define _SO_OBLIQUE_SLICE_DETAIL_

#include <Inventor/details/SoSubDetail.h>
#include <VolumeViz/details/SoSliceDetail.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoObliqueSliceDetail
//
//  Detail about an SoOrthoSlice node.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * @VREXT Stores detail information about a picked voxel on an oblique slice.
 * 
 * @ingroup VolumeVizDetails
 * 
 * @DESCRIPTION
 *   A successful pick operation returns an SoPickedPoint object. If the picked
 *   geometry is an SoObliqueSlice, use the @B getDetail @b method and cast the
 *   result to this class to get extra information about the pick.
 *   
 *   This class contains detail information about a picked voxel on an oblique slice.
 *   The information includes the position of the picked voxel in object coordinate
 *   space (X, Y, Z) and data coordinate space (I, J, K), as well as the value of the
 *   picked voxel.
 *
 * @B Limitations:@b
 *   - If multiple volumes are being combined under an SoMultiDataSeparator,
 *     the detail class only returns values for the first volume in the scene graph.
 * 
 * @SEE_ALSO
 *    SoDetail,
 *    SoSliceDetail,
 *    SoObliqueSlice
 * 
 * 
 */
class VOLUMEVIZ_API SoObliqueSliceDetail : public SoSliceDetail {

  SO_DETAIL_HEADER(SoObliqueSliceDetail);

 public:
   /**
    * Constructor.
    */
   SoObliqueSliceDetail();
   /**
    * Destructor.
    */
   virtual ~SoObliqueSliceDetail();

   /** @copydoc SoDetail::copy() */
   virtual SoDetail* copy() const;

 SoINTERNAL public:
   static void initClass();
   static void exitClass();

private:

  /** Copy constructor */
  SoObliqueSliceDetail(const SoObliqueSliceDetail& detail);
};

#endif /* _SO_OBLIQUE_SLICE_DETAIL_ */

