/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : J. SALLANNE (Sep 2014)
**=======================================================================*/

#ifndef _SO_SLICE_DETAIL_
#define _SO_SLICE_DETAIL_

#include <Inventor/details/SoSubDetail.h>
#include <Inventor/SbPImpl.h>
#include <VolumeViz/nodes/SoVolumeData.h>

class SbPlane;
class SbLine;

SO_PIMPL_BASE_PUBLIC_DECLARATION(SoSliceDetail)

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoSliceDetail
//
//  Abstract class for SoOrthoSliceDetail and SoObliqueSliceDetail nodes.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * @VREXT Base class for detail information about picking in a data volume.
 *
 * @ingroup VolumeVizDetails
 *
 * @DESCRIPTION
 *   A successful pick operation returns an SoPickedPoint object. If the picked
 *   geometry is an SoOrthoSliceDetail or SoObliqueSliceDetail, use the @B getDetail @b method
 *   and cast the result to the appropriate class (SoOrthoSliceDetail or SoObliqueSliceDetail)
 *   to get extra information about the location of the pick.
 *
 *   SoSliceDetail contains detail information about a picked voxel on an ortho or oblique slice.
 *   The information includes the position of the picked voxel in object coordinate space (X, Y, Z)
 *   and data coordinate space (I, J, K), as well as the value of the picked voxel.
 *
 * @B Limitations:@b
 *   - If multiple volumes are being combined under an SoMultiDataSeparator,
 *     the detail class only returns values for the first volume in the scene graph.
 *
 * @SEE_ALSO
 *    SoDetail,
 *    SoOrthoSliceDetail,
 *    SoObliqueSliceDetail,
 *    SoObliqueSlice,
 *    SoOrthoSlice
 *
 */
class VOLUMEVIZ_API SoSliceDetail : public SoDetail {

  SO_DETAIL_HEADER(SoSliceDetail);
  SO_PIMPL_BASE_PUBLIC_HEADER(SoSliceDetail);

 public:
  /**
   * Constructor.
   */
  SoSliceDetail();

  /**
   * Destructor.
   */
  virtual ~SoSliceDetail();

  /** @copydoc SoDetail::copy() */
  virtual SoDetail* copy() const;

  /**
   * @return the position of the picked voxel in object coordinate space (X, Y, Z).
   */
   const SbVec3f& getValueObjectPos() const;

  /**
   * @return the position of the picked voxel in data coordinate space (I, J, K).
   */
  const SbVec3i32& getValueDataPos() const;

  /**
   * @return the value of the picked voxel as an integer.
   */
  int64_t getValue() const;

  /**
   * @return the value of the picked voxel as a floating point value.
   */
  double getValueD() const;

 SoINTERNAL public:
  static void initClass();
  static void exitClass();

 SoEXTENDER public:
  void setDetails(SbPlane p, SbLine line, SoVolumeData* vd);
  void getDetails(SbPlane& p, SbLine& line, SoVolumeData*& vd) const;

 protected:
  /** Copy constructor */
  SoSliceDetail(const SoSliceDetail& detail);

};

#endif /* _SO_SLICE_DETAIL_ */


