/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : T. DUFOUR (Nov 2002)
**=======================================================================*/

#ifndef  _SO_VOLUME_GROUP_ELEMENT_
#define  _SO_VOLUME_GROUP_ELEMENT_

#include <Inventor/elements/SoReplacedElement.h>
#include <Inventor/SbVec.h>

class SoVolumeGroup;

/**
 * @ingroup VolumeVizElements
 */
class VOLUMEVIZ_API SoVolumeGroupElement : public SoReplacedElement {
  SO_ELEMENT_HEADER( SoVolumeGroupElement );

public:

  // Sets/Gets the current volume data attributes in the state
  static void set(SoState* state, SoNode *node, SoVolumeGroup *volumeGroupNode);
  static void get(SoState* state, SoVolumeGroup *&volumeGroupNode);

  // Default values
  static void getDefault(SoVolumeGroup *&VolumeGroupNode);

protected:

  /** Initializes element */
  virtual void init(SoState* state);

  /**  @copydoc SoReplacedElement::copyMatchInfo */
  virtual SoElement* copyMatchInfo() const;

  /** @copydoc SoReplacedElement::matches */
  virtual SbBool matches(const SoElement* elt) const;

  SoINTERNAL public:
  // Initializes the SoVolumeGroupElement class
  static void initClass();
  static void exitClass();
  // Set current number of volumeGroup
  static void setNumberOfVolume(SoState* state, SoNode *node, int numberOfVolume);
  // Return current number of volumeGroup
  static int getNumberOfVolume(SoState* state);

protected:
  virtual void setElt( SoVolumeGroup *VolumeGroupNode );

  virtual ~SoVolumeGroupElement();

private:
  SoVolumeGroup* m_volumeGroupNode;
  int m_numberOfVolume;
};

#endif // _SO_VOLUME_GROUP_ELEMENT_


