/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  SO_HEIGHTFIELD_GEOMETRY_H
#define  SO_HEIGHTFIELD_GEOMETRY_H

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

#include <VolumeViz/nodes/SoVolumeData.h>
#include <Inventor/fields/SoSFFloat.h>

SO_PIMPL_PUBLIC_DECLARATION(SoHeightFieldGeometry)

/**
* @VREXT Height field data node
*
* @ingroup VolumeVizNodes
*
* @DESCRIPTION
* SoHeightFieldGeometry defines a uniform grid in the XY plane whose vertices are
* height (Z) values stored in 2D LDM format (any LDM data set with the Z dimension
* equal to 1).  Storing only height values is a very efficient way to represent a
* surface and LDM supports 8 and 16 bit integer data in addition to float (and other
* types). Adding the combination of LDM data management with advanced GPU features
* provides a way to handle extremely large surfaces. Just as with volume data, LDM
* uses tiles of data and multiple levels of resolution to enable interactive frame
* rates even for data sets that cannot fit in system memory.
*
* SoHeightFieldGeometry is derived from SoVolumeData and serves a similar purpose
* in the scene graph, providing a reference to an LDM data set which will be
* loaded as needed by rendering nodes, specifically SoHeightFieldRender in this case.
* The geometry is given by the inherited field #fileName. The given file must be
* an LDM file built by the LDM converter (see SoConverter). For use with
* SoHeightFieldRender the data set must have a depth (Z dimension) of exactly 1.
* The inherited field #undefinedValue allows to specify an "undefined" value which will
* be rendered as holes in the grid. This value can also be specified with the @I -u @i 
* option of the converter.
*
* Data set values are converted to height values in 3D space in two ways depending
* on the data type:
* - Integer values are normalized between [0,1]  ([-1,1] for signed types)
*   based on the range of values for the specific data type.  For example, for
*   UNSIGNED BYTE values the range 0..255 is mapped to 0..1.
* - Floating point values are not normalized (are used "as is").
*
* Extent in 3D space
*
* A standard SoVolumeData node has no intrinsic "extent" in 3D.  The extent of
* the volume is initially defined by the values returned from the volume reader
* (normally from the extent tag in the LDM file header).  The extent field is
* initialized with these values from the reader and always contains the current
* extent values. The application can modify the extent of the volume by changing
* the values in the extent field. (Note that the actual bounding box of the volume
* in 3D is the volume extent modified by any transform nodes in the scene graph.)
*
* SoHeightFieldGeometry only uses the X and Y parts of the extent field. The Z
* extent of the surface in 3D is completely defined by the values in the data set.
* So the X and Y values in the extent field are the actual extent, but the Z values
* are not meaningful and changing the Z values in the extent field has no effect.
* Note that you can always get the current bounding box (X, Y and Z) using an
* SoGetBoundingBoxAction and you can still control the bounding box using an
* SoTransform (or similar) node. To scale or offset the height values, put a
* transform node in the scene graph before the SoHeightFieldGeometry node.
* For example, to scale the height values by a factor of 2, you could use an
* SoScale node with the scaleFactor field set to (0,0,2).
*
* \warning If you implement your own volume reader, we @I strongly @i recommend implementing
* the method SoVolumeReader::getTileMinMax(). The tile min/max is used to improve the tesselation
* (adjust the number of triangles depending on the difference between min and max).
* Because of the way the height field algorithm works, if tile min/max info is not
* available, VolumeViz must load @I all @i height field tiles before the first render.
* This can cause a long delay before the first rendering appears.
*
* @FILE_FORMAT_DEFAULT
*    HeightFieldGeometry {
*    @TABLE_FILE_FORMAT
*       @TR allocateResourceOnRender   @TD FALSE
*       @TR data                       @TD NODATA 0 0 0 UBYTE 8
*       @TR dataRGBA                   @TD FALSE
*       @TR dataSetId                  @TD 1
*       @TR dataTransform              @TD NULL
*       @TR extent                     @TD -1 -1 -1 1 1 1
*       @TR fileName                   @TD ""
*       @TR texturePrecision           @TD 0
*       @TR undefinedValue             @TD NaN
*       @TR useCompressedTexture       @TD TRUE
*       @TR useExtendedData            @TD FALSE
*       @TR usePalettedTexture         @TD TRUE
*       @TR useSharedPalettedTexture   @TD TRUE
*    @TABLE_END
*    }
*
* @SEE_ALSO
*    SoHeightFieldRender,
*    SoHeightFieldProperty,
*    SoMultiDataSeparator,
*    SoConverter
*
*/
class VOLUMEVIZ_API SoHeightFieldGeometry : public SoVolumeData
{
  SO_NODE_HEADER( SoHeightFieldGeometry );

  SO_PIMPL_PUBLIC_HEADER( SoHeightFieldGeometry );

public:
  /** Constructor */
  SoHeightFieldGeometry();

SoINTERNAL public:
  static void initClass();
  static void exitClass();

  /**
  * Handle field change
  */
  virtual void notify(SoNotList *list);

protected:
  virtual ~SoHeightFieldGeometry();

SoINTERNAL protected:
  virtual unsigned short getMaxTexturePrecisionBits() const override;

#ifndef HIDDEN_FROM_DOC
  // friendship needed by pimpl. These class can access to SoHeightFieldGeometryImpl
  friend class SoHeightFieldRenderTessImpl;
  friend class SoHeightFieldRenderImpl;
  friend class SoHeightFieldRender;
#endif
};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif // SO_HEIGHTFIELD_GEOMETRY_H


