/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Benjamin Longuechaud (May 2013)
**=======================================================================*/


#ifndef  SO_HEIGHTFIELD_PROPERTY_MASK_H
#define  SO_HEIGHTFIELD_PROPERTY_MASK_H

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

#include <VolumeViz/nodes/SoHeightFieldProperty.h>

SO_PIMPL_PUBLIC_DECLARATION(SoHeightFieldPropertyMask)

/**
* @VREXT Height field mask node.
*
* @DESCRIPTION
* SoHeightFieldPropertyMask specifies undefined "cells" in a height field data set.
* The mask is itself a data volume consisting of binary values. The volume values may
* be any supported data type. Zero values are "false" indicating undefined cells
* and non-zero values are "true" indicating valid cells.
*
* A cell is defined by four height values in the SoHeightFieldGeometry data set. Setting
* a value to the undefinedValue in SoHeightFieldGeometry removes that height value from
* the mesh. Setting a cell to undefined in SoHeightFieldPropertyMask effectively removes
* four height values from the mesh.
*
* The dimensions of the SoHeightFieldPropertyMask data set must be exactly the same as
* the dimensions of the corresponding SoHeightFieldGeomerty data set. However, since this
* data set corresponds to cells, if the SoHeightFieldGeometry dimensions are N x N, then
* only (N-1) x (N-1) values in the SoHeightFieldPropertyMask will actually be used.
*
* Note that the inherited undefinedValue field is ignored. Setting it has no effect.
*
* @FILE_FORMAT_DEFAULT
*    HeightFieldPropertyMask {
*    @TABLE_FILE_FORMAT
*       @TR allocateResourceOnRender   @TD FALSE
*       @TR data                       @TD NODATA 0 0 0 UBYTE 8
*       @TR dataRGBA                   @TD FALSE
*       @TR dataSetId                  @TD 1
*       @TR dataTransform              @TD NULL
*       @TR extent                     @TD -1 -1 -1 1 1 1
*       @TR fileName                   @TD ""
*       @TR texturePrecision           @TD 0
*       @TR undefinedValue             @TD NaN
*       @TR useCompressedTexture       @TD TRUE
*       @TR useExtendedData            @TD FALSE
*       @TR usePalettedTexture         @TD TRUE
*       @TR useSharedPalettedTexture   @TD TRUE
*    @TABLE_END
*    }
*
* @SEE_ALSO
*    SoHeightFieldRender,
*    SoHeightFieldGeometry,
*    SoMultiDataSeparator,
*    SoHeightFieldProperty,
*    SoConverter
*
*
*/
class VOLUMEVIZ_API SoHeightFieldPropertyMask : public SoVolumeData
{
  SO_NODE_HEADER( SoHeightFieldPropertyMask );

  SO_PIMPL_PUBLIC_HEADER( SoHeightFieldPropertyMask );

public:
  SoHeightFieldPropertyMask();

SoINTERNAL public:
  static void initClass();
  static void exitClass();
  virtual void notify(SoNotList* list);

protected:
  virtual ~SoHeightFieldPropertyMask();

private:
};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif // SO_HEIGHTFIELD_PROPERTY_MASK_H


