/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Dec 2010)
**=======================================================================*/
#if !defined _SO_UNIFORM_GRID_PROJECTION_CLIPPING_H_
#define _SO_UNIFORM_GRID_PROJECTION_CLIPPING_H_

#include <VolumeViz/nodes/SoUniformGridClipping.h>
#include <Inventor/fields/SoSFNode.h>
#include <Inventor/SbViewportRegion.h>

class SoCamera;
class SoOrthographicCamera;

SO_PIMPL_PUBLIC_DECLARATION(SoUniformGridProjectionClipping);

/** 
 * @VREXT Clips a volume with the depth map projection of a shape.
 *
 * @ingroup VolumeVizNodes
 *
 * @DESCRIPTION
 * This class is an helper class derived from SoUniformGridClipping.
 * It defines its clipping texture by the depth map of the given #sceneGraph 
 * in the given #axis orientation.
 *
 * @B Notes: @b
 *
 * - Rendering the #sceneGraph on top of the clipped volume might result in z-fighting 
 *   artefacts due to depth precision. In order to avoid this issue it is necessary to use
 *   a SoPolygonOffset node before the geometry to render.
 *
 * - #sceneGraph should not contain any draggers or manipulators because they will become
 *   part of the clipping texture and might lead to unwanted results. As a workaround, you can
 *   put draggers outside of #sceneGraph, put an SoTransform inside your #sceneGraph
 *   and connect it to your dragger.
 *
 * - If #sceneGraph contains holes, you should set the #minFilter and #magFilter fields
 *   to NEAREST to avoid interpolation issues between holes and the true surface.
 *
 * - The inherited field SoUniformGridClipping::undefinedValue is set to the default depth (i.e. 1).
 *
 * See SoUniformGridClipping for detailed behavior and limitations.
 *
 * @NODE_SINCE_OIV 8.6
 *
 * @FILE_FORMAT_DEFAULT
 *    UniformGridProjectionClipping {
 *    @TABLE_FILE_FORMAT
 *       @TR sceneGraph               @TD NULL
 *       @TR axis                     @TD Y
 *       @TR extent                   @TD -1,0,-1 1,1,1
 *       @TR filename                 @TD ""
 *       @TR image                    @TD 0 0 0
 *       @TR wrapS                    @TD CLAMP_TO_EDGE
 *       @TR wrapT                    @TD CLAMP_TO_EDGE
 *       @TR model                    @TD MODULATE
 *       @TR enableCompressedTexture  @TD FALSE
 *       @TR blendColor               @TD 0 0 0
 *       @TR enableBorder             @TD FALSE
 *       @TR borderColor              @TD 0 0 0 0
 *       @TR maxAnisotropy            @TD 1.0
 *       @TR minFilter                @TD AUTO
 *       @TR magFilter                @TD AUTO
 *       @TR loadingMode              @TD AUTO
 *       @TR useAutoMipmap            @TD FALSE
 *       @TR internalFormat           @TD AUTO_INTERNAL_FORMAT
 *       @TR thickness                @TD 0
 *       @TR clipBelow                @TD FALSE
 *       @TR clipAbove                @TD TRUE
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *  SoUniformGridClipping,
 *  SoVolumeClippingGroup,
 *  SoPolygonOffset
 *
 */
class VOLUMEVIZ_API SoUniformGridProjectionClipping : public SoUniformGridClipping
{

  SO_NODE_HEADER(SoUniformGridProjectionClipping);

  SO_PIMPL_PUBLIC_HEADER(SoUniformGridProjectionClipping);

public:
  /** Constructor */
  SoUniformGridProjectionClipping();

  /**
   * Scene graph containing shapes to project on the orthogonal plane defined by 
   * #axis field to generate the SoUniformGridClipping height map texture.
   */
  SoSFNode sceneGraph;

  void GLRender(SoGLRenderAction* action);

SoINTERNAL public:
  /** @copydoc SoUniformGridClipping::initClass */
  static void initClass();

  /** @copydoc SoUniformGridClipping::exitClass */
  static void exitClass();

  /** @copydoc SoUniformGridClipping::notify */
  virtual void notify(SoNotList *list);

protected:

  /** Destructor */
  virtual ~SoUniformGridProjectionClipping();

};

#endif // _SO_UNIFORM_GRID_PROJECTION_CLIPPING_H_


