/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef SOVOLUMEMASKGROUP_H
#define SOVOLUMEMASKGROUP_H

#include <VolumeViz/nodes/SoVolumeRendering.h>
#include <Inventor/nodes/SoGroup.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoTextureUnit.h>

class SbVec4ub;
class SoVolumeDataDrawStyle;
class SoTransferFunction;
class SoCache;

/**
* @VREXT Volume mask group.
*
* @ingroup VolumeVizNodes
*
* @DESCRIPTION
*   This node is used to define a collection of one or more volume masks.
*   See SoVolumeMask for details about using volume masks.  Every volume
*   mask node in the scene graph must have an SoVolumeMaskGroup as its
*   parent node.  The SoVolumeMaskGroup node, as well as the SoVolumeData
*   node, must be the child of an SoMultiDataSeparator node because the
*   masks are effectively multiple data volumes.
*
*   This class also defines the constant TRANSFERFUNCTION_INTERSECTION_ID.
*   If a transfer function (SoTransferFunction) with this id exists in the
*   traversal state, that transfer function will be used to color voxels
*   which belong to more than one mask.  See SoVolumeMask for details about
*   the regions defined by volume masks.
*
*   Note that when not using volume masks, the traversal order of
*   transfer functions is important, because each VolumeViz rendering
*   node uses the current (last traversed) transfer function independent
*   of the transfer function ids.  However if an SoVolumeMaskGroup node
*   is traversed before the rendering node (regardless of whether there
*   are any SoVolumeMask nodes in the group), the volume will only be
*   rendered using the transfer function (if any) with the same id value
*   as the volume data node.
*
* @FILE_FORMAT_DEFAULT
*    VolumeMaskGroup {
*    @TABLE_FILE_FORMAT
*    @TABLE_END
*    }
*
* @SEE_ALSO
*    SoVolumeDataDrawStyle,
*    SoVolumeRender,
*    SoVolumeMask,
*    SoMultiDataSeparator,
*    SoTransferFunction
*/
class VOLUMEVIZ_API SoVolumeMaskGroup : public SoGroup
{
  SO_NODE_HEADER(SoVolumeMaskGroup);
public:
  /**
   * Constructor.
   */
  SoVolumeMaskGroup();

  /**
   * Intersections between masks will be rendered with the transfer function
   * with id = TRANSFERFUNCTION_INTERSECTION_ID.
   */
  static short TRANSFERFUNCTION_INTERSECTION_ID;

SoEXTENDER public:
  /** @copydoc SoNode::GLRender */
  virtual void GLRender(SoGLRenderAction *action);
  /** @copydoc SoNode::doAction */
  virtual void doAction(SoAction *action);
  /** @copydoc SoNode::pick */
  virtual void pick(SoPickAction *action);

SoINTERNAL public:
  static void initClass();
  static void exitClass();

  static int getTestTextureUnit(SoGLRenderAction *action);
  static int getStyleTextureUnit(SoGLRenderAction *action);

  /**
   * If set to TRUE, mask are virtually dilated by 1/2 voxel during rendering.
   * This can fix some masking issues when mixing mask and IsoSurface.
   * Isosurface that are near border of mask can goes out of mask because of linear interpolation.
   * Inflating mask make it sure interpolation will not goes outside of mask.
   * Default is FALSE.
   *
   * Used by Avizo. See req#1831 for details.
   */
  SoSFBool isosurfaceCompliance;

  // Size of the vmTex (it is a square texture used to render boundary)
  static const int s_vmTexSize;

protected:
  /** Check if texture must be recreated */
  void updateCache(SoState *state);

  ~SoVolumeMaskGroup();

private:
  struct BoundaryPalette
  {
    /**Init everything to 0*/
    BoundaryPalette();
    unsigned char renderStyle;
    unsigned char padRenderStyle[3];
    unsigned char diffuse[4];
    unsigned char specular[3];
    unsigned char shininess;
  };

  /** Put default intersection DrawStyle on state if needed */
  void setupIntersectionDrawStyle(SoAction* state);

  /**
   * Return the draw style of the masked volume data
   * This drawstyle will be applied on the whole volume
   */
  SoVolumeDataDrawStyle* getVolumeDataDrawStyle(SoState* state);

  /** Activate the boundary texture */
  void bindVmTexture(SoGLRenderAction* action, const SoLDM::DataSetIdPairList& dsList);

  /** Return true if this node can be used.
   * When using a debug build of Open Inventor, some "no context available"
   * warning messages may be generated. You can ignore them or see
   * SoGLExtension for an example of using SoGLContext to avoid them.
  */
  static bool isSupported(SoState* state);

  /** Invalidate all mask textures */
  void invalidateVolumeMaskTextures(SoState* state);

  /** Texture used for the boundary style */
  SoRef<SoTexture2> m_styleTexture;
  SoRef<SoTextureUnit> m_styleTextureUnit;

  /** Texture used for the boundary test */
  SoRef<SoTexture2> m_testTexture;
  SoRef<SoTextureUnit> m_testTextureUnit;

  /** Empty texture unit to reset the texture unit **/
  SoRef<SoTextureUnit> m_emptyTextureUnit;

  SoRef<SoGroup> m_internalSceneGraph;

  /** Check if texture MaskGroup Data invalidation is needed */
  SoCache* m_cacheData;

  /** Check if texture MaskGroup Style invalidation is needed */
  SoCache* m_cacheStyle;

  /** Default drawstyle for intersections */
  SoVolumeDataDrawStyle* m_defaultIntersectionDrawStyle;

  /** Default tf for intersections */
  SoTransferFunction* m_defaultIntersectionTf;

  friend struct SetBoundsColorsAndStyles;
};

#endif


