/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/

#pragma once

#include <VolumeViz/readers/dicom/SoDicomTag.h>

class SiDicomDataSet;
class SiDicomSequence;
class SiDicomValue;

/**
 * @VREXT DICOM data.
 *
 * @ingroup VolumeVizReaders
 *
 * @DESCRIPTION
 * Access data in a DICOM element.
 *
 * An element is identified by its tag, and can contain a value or
 * a sequence but not both. An empty element has no value or sequence.
 *
 * @SEE_ALSO
 *   SoVRDicomFileReader,
 *   SoVRDicomData,
 *   SoDicomTag,
 *   SiDicomDataSet,
 *   SiDicomValue,
 *   SiDicomSequence
 */
class VOLUMEVIZ_API SiDicomElement
{
public:
  /**
   * Destructor
   */
  virtual ~SiDicomElement() {}

  /**
   * Create a clone of the current element.
   *
   * @return a newly created DICOM element, that must be deleted by the
   *         caller.
   */
  virtual SiDicomElement* clone() const = 0;

  /**
   * Get the tag of the element.
   */
  virtual const SoDicomTag& getTag() const = 0;

  /**
   * Get the value of the element.
   *
   * @return a pointer to the value or NULL if the element has no value.
   */
  virtual const SiDicomValue* getValue() const = 0;

  /**
   * Get the sequence contained in the element.
   *
   * @return a pointer to the sequence or NULL if the element has no sequence.
   */
  virtual const SiDicomSequence* getSequence() const = 0;
};
