/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/

#pragma once

#include <Inventor/sys/port.h>

class SiDicomDataSet;

/**
 * @VREXT DICOM data.
 *
 * @ingroup VolumeVizReaders
 *
 * @DESCRIPTION
 * Access data in a DICOM sequence.
 *
 * A DICOM sequence contains a vector of nested data sets, called "items"
 * in this context.
 *
 * @SEE_ALSO
 *   SoVRDicomFileReader,
 *   SoVRDicomData,
 *   SoDicomTag,
 *   SiDicomDataSet,
 *   SiDicomElement,
 *   SiDicomValue,
 */
class VOLUMEVIZ_API SiDicomSequence
{
public:
  /**
   * Destructor
   */
  virtual ~SiDicomSequence() {}

  /**
   * Create a clone of the sequence.
   */
  virtual SiDicomSequence* clone() const = 0;

  /**
   * Get the number of nested data sets contained in this sequence.
   */
  virtual size_t getLength() const = 0;

  /**
   * Get the n-th nested data set.
   *
   * @param  idx the index of the nested data set to get.
   * @return     a pointer to the n-th data set or NULL if idx is greater than
   *             the length of the sequence.
   */
  virtual const SiDicomDataSet* getItem( const size_t idx ) const = 0;
};
