#ifndef OIV_LEGACY_SHADER_HELPER_H
#define OIV_LEGACY_SHADER_HELPER_H
// For convenience when migrating legacy GLSL shaders.
// Initializes legacy point and material parameter structs.

//!oiv_include <Inventor/oivShaderState.h>

///////////////////////////////////////////////////////////////////////////////
// Replaces:
//   uniform gl_MaterialParameters gl_FrontMaterial;
//   uniform gl_MaterialParameters gl_BackMaterial;

gl_MaterialParameters OivFrontMaterial()
{
    gl_MaterialParameters mat;
    mat.emission  = OivFrontMaterialEmissive();
    mat.ambient   = OivFrontMaterialAmbient();
    mat.diffuse   = OivFrontMaterialDiffuse();
    mat.specular  = OivFrontMaterialSpecular();
    mat.shininess = OivFrontMaterialShininess();
    return mat;
}

gl_MaterialParameters OivBackMaterial()
{
    gl_MaterialParameters params;
    params.emission  = OivBackMaterialEmissive();
    params.ambient   = OivBackMaterialAmbient();
    params.diffuse   = OivBackMaterialDiffuse();
    params.specular  = OivBackMaterialSpecular();
    params.shininess = OivBackMaterialShininess();
    return params;
}

///////////////////////////////////////////////////////////////////////////////
// Replaces
//   uniform gl_LightSourceParameters gl_LightSource[gl_MaxLights];
//
// Notes:
//   - Name "OivLightSource" is already used in oivShaderState.h
//   - gl_LightSourceParameters.halfVector is not supported

gl_LightSourceParameters OivLightSourceParameters( int i )
{
    gl_LightSourceParameters params;
    params.ambient = OivLightSourceAmbient(i);
    params.diffuse = OivLightSourceDiffuse(i);
    params.specular = OivLightSourceSpecular(i);
    params.position = OivLightSourcePosition(i);
    //params.halfVector = OivLightSourceHalfVector(i);
    params.spotDirection = OivLightSourceSpotDirection(i);
    params.spotExponent = OivLightSourceSpotExponent(i);
    params.spotCutoff = OivLightSourceSpotCutoff(i);
    params.spotCosCutoff = OivLightSourceSpotCosCutoff(i);
    params.constantAttenuation = OivLightSourceConstantAttenuation(i);
    params.linearAttenuation = OivLightSourceLinearAttenuation(i);
    params.quadraticAttenuation = OivLightSourceQuadraticAttenuation(i);
    return params;
}

///////////////////////////////////////////////////////////////////////////////
// Replaces:
//   uniform gl_LightModelParameters gl_LightModel;
gl_LightModelParameters OivLightModel()
{
  gl_LightModelParameters params;
  params.ambient = OivGlobalAmbient(); // Acs
  return params;
};

///////////////////////////////////////////////////////////////////////////////
// Replaces:
//   uniform gl_LightModelProducts gl_FrontLightModelProduct;
//   uniform gl_LightModelProducts gl_BackLightModelProduct;
gl_LightModelProducts OivFrontLightModelProduct()
{
  gl_LightModelProducts params;
  params.sceneColor = // vec4 Derived. Ecm + Acm * Acs
    OivFrontMaterialEmissive() + OivFrontMaterialAmbient() * OivGlobalAmbient();
  return params;
};

gl_LightModelProducts OivBackLightModelProduct()
{
  gl_LightModelProducts params;
  params.sceneColor = // vec4 Derived. Ecm + Acm * Acs
    OivBackMaterialEmissive() + OivBackMaterialAmbient() * OivGlobalAmbient();
  return params;
};

///////////////////////////////////////////////////////////////////////////////
// Replaces:
//   uniform gl_LightProducts gl_FrontLightProduct[gl_MaxLights];
//   uniform gl_LightProducts gl_BackLightProduct[gl_MaxLights];

gl_LightProducts OivFrontLightProduct( int i )
{
    gl_LightProducts params;
    params.ambient  = OivFrontLightProductAmbient(i);
    params.diffuse  = OivFrontLightProductDiffuse(i);
    params.specular = OivFrontLightProductSpecular(i);
    return params;
}

gl_LightProducts OivBackLightProduct( int i )
{
    gl_LightProducts params;
    params.ambient  = OivBackLightProductAmbient(i);
    params.diffuse  = OivBackLightProductDiffuse(i);
    params.specular = OivBackLightProductSpecular(i);
    return params;
}

///////////////////////////////////////////////////////////////////////////////
// Replaces:
//   uniform gl_FogParameters gl_Fog;
gl_FogParameters OivFogParameters()
{
  gl_FogParameters params;
  params.color   = OivFogColor();
  params.density = OivFogDensity();
  params.start   = OivFogStart();
  params.end     = OivFogEnd();
  params.scale   = OivFogScale();
  return params;
};

///////////////////////////////////////////////////////////////////////////////
// Replaces:
//   uniform gl_PointParameters gl_Point;
// WARNING: Not possible to fully implement this.
gl_PointParameters OivPointParameters()
{
  gl_PointParameters params;
  params.size = gl_PointSize;
  params.sizeMin = 0;
  params.sizeMax = 0;
  params.fadeThresholdSize = 0;
  params.distanceConstantAttenuation = 0;
  params.distanceLinearAttenuation = 0;
  params.distanceQuadraticAttenuation = 0;
  return params;
};

#endif