/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/

#include <Inventor/ViewerComponents/MFC/RenderAreaExaminer.h>

#include "winUser.h"

BEGIN_MESSAGE_MAP( RenderAreaExaminer, CWnd )
  ON_WM_LBUTTONDOWN()
  ON_WM_MBUTTONDOWN()
  ON_WM_RBUTTONDOWN()
  ON_WM_LBUTTONUP()
  ON_WM_MBUTTONUP()
  ON_WM_RBUTTONUP()
  ON_WM_LBUTTONDBLCLK()
  ON_WM_MBUTTONDBLCLK()
  ON_WM_RBUTTONDBLCLK()
  ON_WM_MOUSEMOVE()
  ON_WM_MOUSEWHEEL()
  ON_WM_PAINT()
  ON_WM_SIZE()
  ON_WM_MOUSELEAVE()
  ON_WM_VSCROLL()
  ON_WM_SETCURSOR()
END_MESSAGE_MAP()

HCURSOR RenderAreaExaminer::s_seekCursor;
HCURSOR RenderAreaExaminer::s_viewingCursor;
HCURSOR RenderAreaExaminer::s_selectionCursor;

//------------------------------------------------------------------------------
RenderAreaExaminer::RenderAreaExaminer()
  : RenderAreaInteractive(false)
{
  // Set cursor
  RenderAreaExaminer::s_seekCursor = AfxGetApp()->LoadStandardCursor(IDC_CROSS);
  RenderAreaExaminer::s_viewingCursor = AfxGetApp()->LoadStandardCursor(IDC_HAND);
  RenderAreaExaminer::s_selectionCursor = AfxGetApp()->LoadStandardCursor(IDC_ARROW);

  // Disable SceneExaminer automatic adjustment of clipping planes,
  // adjustment is managed by the render area.
  SoPreferences::setBool("OIV_SCENE_EXAMINER_AUTO_CLIPPING_PLANES", false);
  // Deactivate auto interactive mode,
  // interactive mode is managed by the SceneExaminer.
  m_isAutoInteractive = false;

  m_rootSceneGraph = m_examinerRootSceneGraph = new SceneExaminer();
  // Listening interaction from the scene examiner
  m_examinerRootSceneGraph->addInteractionModeListener(this);
  // Init cursor shape
  updateInteractionCursor();

  buildSceneGraph();
}

//------------------------------------------------------------------------------
BOOL RenderAreaExaminer::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
  ::SetCursor(s_currentCursor);
  return TRUE;
}

//------------------------------------------------------------------------------
SceneExaminer*
RenderAreaExaminer::getSceneExaminer()
{
  return m_examinerRootSceneGraph;
}

//------------------------------------------------------------------------------
SceneExaminer*
RenderAreaExaminer::getSceneInteractor() const
{
  return m_examinerRootSceneGraph;
}

//------------------------------------------------------------------------------
void
RenderAreaExaminer::setNavigationMode( SceneExaminer::NavigationMode mode )
{
  m_examinerRootSceneGraph->setNavigationMode( mode );
  updateInteractionCursor();
}

//------------------------------------------------------------------------------
SceneExaminer::NavigationMode
RenderAreaExaminer::getNavigationMode()
{
  return m_examinerRootSceneGraph->getNavigationMode();
}

//------------------------------------------------------------------------------
void
RenderAreaExaminer::seekModeChanged(const bool seek)
{
  if (seek)
  {
    s_currentCursor = s_seekCursor;
    SetCursor( s_currentCursor );
  }
  else
  {
    updateInteractionCursor();
  }
}

//------------------------------------------------------------------------------
void
RenderAreaExaminer::interactionModeChanged(SceneExaminer::InteractionMode mode)
{
  updateInteractionCursor();
}

//------------------------------------------------------------------------------
void
RenderAreaExaminer::updateInteractionCursor()
{
  if ( ( ( SceneExaminer* )getSceneInteractor() )->getInteractionMode() == SceneExaminer::NAVIGATION )
  {
    s_currentCursor = s_viewingCursor;
  }
  else
  {
    s_currentCursor = s_selectionCursor;
  }
  SetCursor(s_currentCursor);
}