#include "CustomSliderControl.h"
//#include "MainFrame.h"
#include <sstream>
#include <iomanip>

BEGIN_MESSAGE_MAP( CustomSliderControl, CSliderCtrl )
  ON_WM_LBUTTONUP()
END_MESSAGE_MAP()

//------------------------------------------------------------------------------
CustomSliderControl::CustomSliderControl( StereoPropertiesDialog::SliderName name, StereoPropertiesDialog* dialog,
                                          CStatic* sliderLabel, float realMinValue, float realMaxValue )
: CSliderCtrl()
, m_name( name )
, m_dialog( dialog )
, m_sliderLabel( sliderLabel )
, m_realMinValue( realMinValue )
, m_realMaxValue( realMaxValue )
, m_realValue( 0.0f )
{
}

//------------------------------------------------------------------------------
void
CustomSliderControl::setRealValue( float realValue )
{
  int min, max;
  GetRange( min, max );

  // Conversion from real value to slider position
  const float range = float( max ) - float( min );
  const float realRange = m_realMaxValue - m_realMinValue;
  const int value = min + int( ((realValue - m_realMinValue) * range / realRange) + 0.5f );

  SetPos( value );

  updateRealValue();
}

//------------------------------------------------------------------------------
void
CustomSliderControl::updateRealValue()
{
  int min, max;
  GetRange( min, max );

  // Conversion from slider position to real value
  const float range = float( max ) - float( min );
  const float realRange = m_realMaxValue - m_realMinValue;
  const float value = float( GetPos() );
  m_realValue = m_realMinValue + (value / range) * realRange;

  // Update label display value
  std::stringstream stream;
  stream << std::fixed << std::setprecision( 2 ) << m_realValue;
  const std::string string = stream.str();
  m_sliderLabel->SetWindowText( string.c_str() );
}

//------------------------------------------------------------------------------
void
CustomSliderControl::OnLButtonUp( UINT nFlags, CPoint point )
{
  if ( !m_continuousUpdate )
    m_dialog->updateStereoProperty( m_name );

  CSliderCtrl::OnLButtonUp( nFlags, point );
}
