#include <Inventor/ViewerComponents/MFC/Viewers/ViewerExaminer.h>
#include "StereoPropertiesDialog.h"
#include "CustomSliderControl.h"
#include "res/resource.h"


BEGIN_MESSAGE_MAP(StereoPropertiesDialog, CDialog)
  ON_BN_CLICKED(IDC_STEREO_TOGGLE, StereoPropertiesDialog::OnStereoToggle)
  ON_BN_CLICKED(IDC_STEREO_BALANCE_TOGGLE, StereoPropertiesDialog::OnStereoBalanceToggle)
  ON_BN_CLICKED(IDC_STEREO_OFFSET_TOGGLE, StereoPropertiesDialog::OnStereoOffsetToggle)
  ON_WM_HSCROLL()
END_MESSAGE_MAP()

//------------------------------------------------------------------------------
StereoPropertiesDialog::~StereoPropertiesDialog()
{
  for (size_t i = 0; i < m_sliders.size(); i++)
    delete m_sliders[i];
}

//------------------------------------------------------------------------------
BOOL
StereoPropertiesDialog::OnInitDialog()
{
  CDialog::OnInitDialog();

  m_toggleStereoButton = (CButton*)GetDlgItem(IDC_STEREO_TOGGLE);
  m_toggleBalanceButton = (CButton*)GetDlgItem(IDC_STEREO_BALANCE_TOGGLE);
  m_toggleOffsetButton = (CButton*)GetDlgItem(IDC_STEREO_OFFSET_TOGGLE);
  m_balanceValue = (CStatic*)GetDlgItem(IDC_STEREO_BALANCE_VALUE);
  m_offsetValue = (CStatic*)GetDlgItem(IDC_STEREO_OFFSET_VALUE);

  m_toggleStereoButton->SetCheck(FALSE);
  m_toggleBalanceButton->SetCheck(FALSE);
  m_toggleOffsetButton->SetCheck(FALSE);

  m_sliders[BALANCE] = new CustomSliderControl(BALANCE, this, m_balanceValue, -3.0, 3.0);
  m_sliders[BALANCE]->setContinuousUpdate(false);
  m_sliders[BALANCE]->Create(TBS_HORZ | TBS_NOTICKS, RECT(), this, IDC_STEREO_BALANCE_SLIDER);
  m_sliders[BALANCE]->MoveWindow(170, 62, 140, 35);
  m_sliders[BALANCE]->SetRange(0, 102);
  m_sliders[BALANCE]->setRealValue(1.0f);
  m_sliders[BALANCE]->ShowWindow(SW_SHOW);

  m_sliders[OFFSET] = new CustomSliderControl(OFFSET, this, m_offsetValue, 0.0, 2.0);
  m_sliders[OFFSET]->setContinuousUpdate(false);
  m_sliders[OFFSET]->Create(TBS_HORZ | TBS_NOTICKS, RECT(), this, IDC_STEREO_OFFSET_SLIDER);
  m_sliders[OFFSET]->MoveWindow(170, 94, 140, 35);
  m_sliders[OFFSET]->SetRange(0, 100);
  m_sliders[OFFSET]->setRealValue(0.7f);
  m_sliders[OFFSET]->ShowWindow(SW_SHOW);

  return TRUE;
}

//------------------------------------------------------------------------------
void
StereoPropertiesDialog::OnStereoToggle()
{
  ViewerExaminer* parent = (ViewerExaminer*)GetParentFrame();
  const int checked = !m_toggleStereoButton->GetCheck();
  parent->activateStereo(checked != 0);
  m_toggleStereoButton->SetCheck(checked);
}

//------------------------------------------------------------------------------
void
StereoPropertiesDialog::OnStereoBalanceToggle()
{
  const int checked = !m_toggleBalanceButton->GetCheck();
  m_sliders[BALANCE]->setContinuousUpdate(checked != 0);
  m_toggleBalanceButton->SetCheck(checked);
}

//------------------------------------------------------------------------------
void
StereoPropertiesDialog::OnStereoOffsetToggle()
{
  const int checked = !m_toggleOffsetButton->GetCheck();
  m_sliders[OFFSET]->setContinuousUpdate(checked != 0);
  m_toggleOffsetButton->SetCheck(checked);
}

//------------------------------------------------------------------------------
void
StereoPropertiesDialog::updateStereoProperty(SliderName sliderName)
{
  ViewerExaminer* parent = (ViewerExaminer*)GetParentFrame();

  const float value = m_sliders[sliderName]->getRealValue();

  // Choose which stereo property to update based on the slider enum value
  switch (sliderName)
  {
  case BALANCE:
    parent->setStereoCameraBalance(value);
    break;
  case OFFSET:
    parent->setStereoCameraOffset(value);
    break;
  default:
    break;
  }
}

//------------------------------------------------------------------------------
void
StereoPropertiesDialog::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
  // ID of the slider that has been dragged
  const int CtrlID = pScrollBar->GetDlgCtrlID();

  SliderName sliderName = NUM_SLIDERS;

  // Choose slider enum value based on the slider ID
  switch (CtrlID)
  {
  case IDC_STEREO_BALANCE_SLIDER:
    sliderName = BALANCE;
    break;
  case IDC_STEREO_OFFSET_SLIDER:
    sliderName = OFFSET;
    break;
  default:
    break;
  }

  if (sliderName < NUM_SLIDERS)
  {
    m_sliders[sliderName]->updateRealValue();
    if (m_sliders[sliderName]->isUpdateContinuous())
      updateStereoProperty(sliderName);
  }

  // Default handling if not a slider control.
  CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

//------------------------------------------------------------------------------
void
StereoPropertiesDialog::enableControls(bool enable)
{
  const BOOL bEnable = enable ? TRUE : FALSE;

  m_toggleStereoButton->EnableWindow(bEnable);
  m_toggleBalanceButton->EnableWindow(bEnable);
  m_toggleOffsetButton->EnableWindow(bEnable);
  m_balanceValue->EnableWindow(bEnable);
  m_offsetValue->EnableWindow(bEnable);

  for (size_t i = 0; i < m_sliders.size(); i++)
    m_sliders[i]->EnableWindow(bEnable);
}
