#pragma once

#include <Inventor/sys/port.h>
#include <Inventor/ViewerComponents/MFC/StdAfx.h>
#include <array>

class CustomSliderControl;

/**
* Implements the stereo properties dialog box
*/
class MFCVIEWERCOMPONENTS_API StereoPropertiesDialog : public CDialog
{
public:

  /**
  * Sliders used in the stereo properties
  */
  enum SliderName
  {
    BALANCE,
    OFFSET,
    NUM_SLIDERS,
  };

  ~StereoPropertiesDialog();

  /** Update a stereo property based on which slider has been moved. */
  void updateStereoProperty(SliderName sliderName);

  /** Enable or disable controls for this dialog */
  void enableControls(bool enable);

protected:

  // MFC Callbacks

  /** Called on dialog creation */
  afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);

  /** Called when a slider is moved */
  afx_msg virtual void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);

  /** Called when the "Activate raw stereo" checkbox is clicked on */
  afx_msg void OnStereoToggle();

  /** Called when the balance slider checkbox is clicked on */
  afx_msg void OnStereoBalanceToggle();

  /** Called when the offset slider checkbox is clicked on */
  afx_msg void OnStereoOffsetToggle();

  /** Called on dialog init */
  virtual BOOL OnInitDialog();


  CButton* m_toggleStereoButton;  /** "Activate raw stereo" checkbox */
  CButton* m_toggleBalanceButton; /** Balance slider checkbox */
  CButton* m_toggleOffsetButton;  /** Offset slider checkbox */
  CStatic* m_balanceValue;        /** Balance value label */
  CStatic* m_offsetValue;         /** Offset value label */

  /** Array of sliders */
  std::array<CustomSliderControl*, NUM_SLIDERS> m_sliders;

  DECLARE_MESSAGE_MAP()
};