/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/

#include <Inventor/ViewerComponents/Qt/QtTimer.h>

//------------------------------------------------------------------------------
QtTimer::QtTimer()
  : m_task(NULL), m_delay(0)
{
  connect( this, &QtTimer::startRequired, this, &QtTimer::onStart );
  connect( this, &QtTimer::stopRequired, &timer, &QTimer::stop );
}

//------------------------------------------------------------------------------
void
QtTimer::stop()
{
  // send a signal to execute in Qt GUI thread,
  // QTimer must be used in any thread that has an event loop
  emit stopRequired();
}

//------------------------------------------------------------------------------
void
QtTimer::start()
{
  // send a signal to execute in Qt GUI thread,
  // QTimer must be used in any thread that has an event loop
  emit startRequired();
}

//------------------------------------------------------------------------------
void
QtTimer::onStart()
{
  timer.start( m_delay );
}

//------------------------------------------------------------------------------
void
QtTimer::setDelay(int time)
{
  m_delay = time;
}

//------------------------------------------------------------------------------
bool
QtTimer::isPending() const
{
  return timer.isActive();
}

//------------------------------------------------------------------------------
void
QtTimer::setRepeat(bool flag)
{
  timer.setSingleShot(!flag);
}

//------------------------------------------------------------------------------
void
QtTimer::setTask(SoSystemTimerTask* task)
{
  m_task = task;
  connect(&timer, SIGNAL(timeout()), this, SLOT(execCallback()));
}

//------------------------------------------------------------------------------
void
QtTimer::execCallback()
{
  if ( m_task.ptr() != NULL )
    m_task->run();
}
